/* 

	This function will prepare a settings snippet for display as soon as the settings tab is entered

*/

var fs = require('fs');
var path = require('path');

var verbose = false;

//Globals
var woundConfigFile = __dirname + '/config/master.json';
var relImagePath = "../../photos";
var mainConfigFile = __dirname + '/../../config.json';
var mainMedImagePath = path.relative(process.cwd(), __dirname + '/' + relImagePath);


//Include shared funcs
var readConfig = require(__dirname + '/common/libfuncs.js').readConfig;




readConfigFile = mainConfigFile;
 
//Read the main config
readConfig(readConfigFile, function(mainConf, err) {

   if(err) {
	 //There was a problem loading the config
	 console.log("Error reading config file:" + err);
	 process.exit(0);
		 
   } else {

		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {

		 //Locked down - don't allow any editing.
		 var lockDown = "disabled";   
		} else {
		 var lockDown = "";
		}

		//Ok to allow editing

		readConfigFile = woundConfigFile;

		//Read the config
		readConfig(readConfigFile, function(conf, err) {

				   if(err) {
					 //There was a problem loading the config
					 console.log("Error reading config file:" + err);
					 process.exit(0);
		 
				   } else {
							   
					   var area = conf.input.sticker.physicalAreaSquareCm;
	   
					   var autoWound = "";
					   if(conf.input && conf.input.wound && conf.input.wound.autoWoundDetection) {
						  if((conf.input.wound.autoWoundDetection == true)||(conf.input.wound.autoWoundDetection == "true")) {
							autoWound = "checked=\"checked\"";
						  } 
					   }
	   
					   var autoCapitaliseID = "";
					   if(conf.output && conf.output.hasOwnProperty("autoCapitaliseID")) {
						  if((conf.output.autoCapitaliseID === true)||(conf.output.autoCapitaliseID === "true")) {
								
						  } else {
						  		//An input 'false' switches it on
						  		autoCapitaliseID = "checked=\"checked\"";
						  }
					   } else {
					   		
					   }
					   
					   var ajServer = "";
					   if(conf.output && conf.output.ajServer) {
					   		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {
					   			ajServer = "Private";		//Don't display under lockdown
					   		} else {
					   			ajServer = conf.output.ajServer;
					   		}
					   }
					   
					   var ajRoot = "";
					   if(conf.output && conf.output.ajRoot) {
					   		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {
					   			ajRoot = "Private";		//Don't display under lockdown
					   		} else {
					   			ajRoot = conf.output.ajRoot;
					   		}
					   }
					   
					   var ajCSS = "";
					   if(conf.output && conf.output.ajCSS) {
					   		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {
					   			ajCSS = "Private";		//Don't display under lockdown
					   		} else {
					   			ajCSS = conf.output.ajCSS;
					   		}
					   }
					   
					   var ajJS = "";
					   if(conf.output && conf.output.ajJS) {
					   		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {
					   			ajJS = "Private";		//Don't display under lockdown
					   		} else {
					   			ajJS = conf.output.ajJS;
					   		}
					   }
					   
					   var ajBaseCSS = "";
					   if(conf.output && conf.output.ajBaseCSS) {
					   		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {
					   			ajBaseCSS = "Private";		//Don't display under lockdown
					   		} else {
					   			ajBaseCSS = conf.output.ajBaseCSS;
					   		}
					   }
					   
					   var ajMachineUser = "";
					   if(conf.output && conf.output.ajMachineUser) {
					   		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {
					   			ajMachineUser = "Private";		//Don't display under lockdown
					   		} else {
					   			ajMachineUser = conf.output.ajMachineUser;
					   		}
					   }
					   
					   var ajDomain = "";
					   if(conf.output && conf.output.ajDomain) {
					   		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {
					   			ajDomain = "Private";		//Don't display under lockdown
					   		} else {
					   			ajDomain = conf.output.ajDomain;
					   		}
					   }
					   
					   
					   var woundTracing = "";
					   if(conf.output && conf.output.woundTracing) {
					   		if((mainConf.lockDown)&&(mainConf.lockDown == true)) {
					   			woundTracing = "Private";		//Don't display under lockdown
					   		} else {
					   			woundTracing = conf.output.woundTracing;
					   		}
					   }
					   
					   
					   var d = new Date();
					   var thisDatetime = d.toISOString();
	  
					   console.log("returnParams:?AREAVAL=" + area + "&AUTOWOUNDVAL=" + autoWound + "&AUTOCAPITALVAL=" + autoCapitaliseID + "&LOCKDOWN=" + lockDown + "&AJSERVER=" + ajServer + "&AJROOT=" + ajRoot + "&AJCSS=" + ajCSS + "&AJJS=" + ajJS + "&AJBASECSS=" + ajBaseCSS + "&AJMACHINEUSER=" + ajMachineUser + "&AJDOMAIN=" + ajDomain + "&WOUNDTRACING=" + woundTracing + "&THISDATETIME=" + thisDatetime);
	   
					}
		});
	}
});
