/*

MedImage Wound Analysis Add-on - Display area
==============================

Developed by (C) AtomJump Ltd. 10 Aug 2017. This is a commercial add-on to MedImage, and is licensed
by AtomJump on a per-server basis.

This script will read a given photo, and display the area of that photo

*/


var fs = require('fs');
var upath = require('upath');
var queryString = require('querystring');
var fsExtra = require('fs-extra');
var path = require('path');
var glob = require('glob');
var async = require('async');
var resolve = require('path').resolve;


var globalConfigFile = __dirname + '/../../config.json';
var masterConfigFile = __dirname + '/config/master.json';
var relImagePath = "../../photos";		//relative to this script
var mainMedImagePath = path.relative(process.cwd(), __dirname + '/' + relImagePath);
var nonRelativeMedImagePath = __dirname + '/' + relImagePath;
var medPhotosRelativePath = "photos/";
var imagesStart = "/photos";				//
var thumbnailString = ".thumbnail.";		//The default values from the master config - to be used when we can't load the master config for some reason
var replaceText = ".jpg";					//The default values from the master config - to be used when we can't load the master config for some reason
var withWebViewText =  ".web-view.jpg";		//The default values from the master config - to be used when we can't load the master config for some reason



var verbose = false;



//Include shared funcs
var normalizeInclWinNetworks = require(__dirname + '/common/libfuncs.js').normalizeInclWinNetworksStyle;
var readConfig = require(__dirname + '/common/libfuncs.js').readConfig;
var writeConfig = require(__dirname + '/common/libfuncs.js').writeConfig;




//Note: difference here from get-photos is we don't have the master config loaded. So we will do that below and modify the default paths

function rearrangePaths(globalConfig) {
		
		//Relative to this script
		if(globalConfig.backupTo && globalConfig.backupTo[0]) {
			
		
			//And imagesStart, which is relative to the current server directory
			/* OLD as we now only have active photos in our own folder
			var platform = process.platform;
			var isWin = /^win/.test(platform);
			if(isWin) {
				imagesStart = normalizeInclWinNetworks(path.relative(process.cwd(),globalConfig.backupTo[0]));	
				mainMedImagePath = path.relative(process.cwd(), globalConfig.backupTo[0]);
				nonRelativeMedImagePath = globalConfig.backupTo[0];	 
			} else {
				imagesStart = globalConfig.backupTo[0];
				mainMedImagePath = path.relative(process.cwd(), globalConfig.backupTo[0]);	
				nonRelativeMedImagePath = globalConfig.backupTo[0];	 
			}
			*/
		
		
			if(verbose == true) console.log("mainMedImagePath:" + mainMedImagePath);
			if(verbose == true) console.log("imagesStart:" + imagesStart);
		}
		
		return;
}








//Create a platform unspecific globber called myGlob(absolutepath, cb(err, list));
var platform = process.platform;
var isWin = /^win/.test(platform);
if(isWin) {
	//A windows style glob
	
	var targetDrive = "C:\\";
	var winSharedDrive = false;

	
	
	var glob = require('glob-fs')({ gitignore: true, nocase: true });
	myGlob = function(searchAbs, cb) {
		var searchRel = upath.relative(process.cwd(), searchAbs);
		if(verbose == true) console.log("Relative path in unix terms:" + searchRel);
		
		/*
			On Windows in a shared drive environment, we'll need:
			//process.chdir('P://');
			//var searchRel = ".//WoundMapp//CHECK2//*";
		
			Note: the double slashes. And we need to change the drive letter. A raw network path doesn't
			seem to work with glob-fs.
			
		*/

		var winSharedDrive = false;
		if((searchAbs[1]) && (searchAbs[1] == ':') && (searchAbs[0].toUpperCase() != 'C')) {
			winSharedDrive = true;
			//Very Likely a Windows path. 
			//Change the drive folder.
			var oldCwd = process.cwd();
			targetDrive = searchAbs.charAt(0).toUpperCase() + ":\\";			//Change the global var
			process.chdir(searchAbs.charAt(0).toUpperCase() + "://");
			searchRel = upath.relative(process.cwd(), searchAbs);
			if(verbose == true) console.log("Relative path in unix terms from new shared drive letter:" + searchRel); 
			
			//Double up the slashes.
			searchRel = searchRel.replace(/\//g, '\/\/');
			
			if(verbose == true) console.log("glob-fs search path:" + searchRel); 
		}
		
		glob.readdir(searchRel, { "nocase": true }, function(err, list) {
			
			if(err) {
				
					console.log("Error searching. Error:" + err);
			} 
			if(winSharedDrive == true) {
				//Return to our old folder
				process.chdir(oldCwd);
			}
			cb(err,list);
		});		//nocase doesn't work here on Win for some reason
	
	
	}
} else {
	//A unix style glob
	
	
	
	myGlob = function(searchAbs, cb) {	
		glob(searchAbs, { "nocase": true }, cb);	
	}
}



function trimChar(string, charToRemove) {
    while(string.substring(0,1) == charToRemove) {
        string = string.substring(1);
    }

    while(string.slice(-1) == charToRemove) {
        string = string.slice(0, -1);
    }

    return string;
}

function afterStr(str, searchFor)
{


	var c = str.indexOf(searchFor);
	if (c >= -1)
	{
		// Returns the portion not including the search string;
		// in this example, "Here is a <a>link". If you want the
		// search string included, add the length of the search
		// string to c.
		var start = c + searchFor.length;
		return str.substr(start);
		
	} else {
		return str;
	}

}

function createDateAsUTC(date) {
    return new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()));
}



function getMonthFromString(mon){
	//Courtesy https://stackoverflow.com/questions/13566552/easiest-way-to-convert-month-name-to-month-number-in-js-jan-01
   return new Date(Date.parse(mon +" 1, 2012")).getMonth()+1;
}



function displayCalcImprovement(outputHTML, startWoundSize, endWoundSize, startDate, endDate, startUnderSize, endUnderSize, startExternalSize, endExternalSize)
{

	var output = calcImprovement(outputHTML, startWoundSize, endWoundSize, startDate, endDate, startUnderSize, endUnderSize, startExternalSize, endExternalSize);
				
		
	if(output.fullMsg) {
		outputHTML = "<div class='row'><div class='col-lg-4'><br/><div class='panel " + output.showColour + "'><div class='panel-heading'><div class='row'><div class='col-xs-10 col-md-10'>Progress</div><div class='col-xs-2 col-md-2'><a style='float: right;' href='http://medimage.co.nz/addon-wound-analysis-guide/#improvements' target='_blank' title='Help' style='color:#FFF;'><i class='fa fa-question-circle fa-lg fa-fw'></i></a></div></div></div><div class='panel-body'>" + output.fullMsg + "</div></div></div><div class='col-lg-4'><br/><div id=\"messaging\" style=\"MESSAGING\" title='Discuss this injury'><a class=\"comment-open\" data-uniquefeedbackid=\"AJFORUM\" href=\"javascript:\"><img style=\"width: 26%;\" src=\"../images/speech-bubble-start-1.png\"></a>&nbsp;<a class=\"comment-open\" data-uniquefeedbackid=\"AJGLOBALFORUM\" title='Ask for an opinion from all users' href=\"javascript:\"><i style='color: RGB(136,136,136);' class='fa fa-flag fa-3x fa-fw'></i></a></div><br/></div></div>" + outputHTML;

	
	} else {	
		outputHTML = "<div class='row'><div class='col-lg-4'><br/><div class='panel " + output.showColour + "'><div class='panel-heading'><div class='row'><div class='col-xs-10 col-md-10'>Progress</div><div class='col-xs-2 col-md-2'><a style='float: right;' href='http://medimage.co.nz/addon-wound-analysis-guide/#improvements' target='_blank' title='Help' style='color:#FFF;'><i class='fa fa-question-circle fa-lg fa-fw'></i></a></div></div></div><div class='panel-body'><span style='front-size: large;'>Wound Improvement <b>" + output.improvement + "%</b> in <b>" + output.timeDiff + "</b>  " + output.underminingStr + "</div></div></div><div class='col-lg-4'><br/><div id=\"messaging\" style=\"MESSAGING\"><a class=\"comment-open\" data-uniquefeedbackid=\"AJFORUM\" href=\"javascript:\" title='Discuss this injury'><img style=\"width: 26%;\" src=\"../images/speech-bubble-start-1.png\"></a> &nbsp;<a class=\"comment-open\" data-uniquefeedbackid=\"AJGLOBALFORUM\" href=\"javascript:\" title='Ask for an opinion from all users'><i style='color: RGB(136,136,136);' class='fa fa-flag fa-3x fa-fw'></i></a></div><br/></div></div>" + outputHTML;
		

	}
	
	return outputHTML;
	
}

function calcImprovement(outputHTML, startWoundSize, endWoundSize, startDate, endDate, startUnderSize, endUnderSize, startExternalSize, endExternalSize)
{
   var underminingStr = "";
   var output = {};

   //Now show the % improvement. E.g. if a wound started out being 4.5 sqcm, and becomes
   //1.9 sqcm, the percent improvement would be ((4.5 - 1.9) / 4.5) * 100 = 57% improvement
   if((startWoundSize) && (endWoundSize)) {
   
		
   
		var improvement = ((startWoundSize - endWoundSize) / startWoundSize) * 100;
		improvement = Math.round( improvement * 10) / 10;
		
		
		if(startUnderSize) {
			//Handle undermining
			var underImprovement = "NA";
			var externalImprovement = "NA";
			
			
			var thisImprovement = ((startUnderSize - endUnderSize) / startUnderSize) * 100;
			thisImprovement = Math.round( thisImprovement * 10) / 10;
			if(isNaN(thisImprovement) == false) {
				underImprovement = thisImprovement.toFixed(1);
			}
			
			var thisImprovement = ((startExternalSize - endExternalSize) / startExternalSize) * 100;
			thisImprovement = Math.round( thisImprovement * 10) / 10;
			if(isNaN(thisImprovement) == false) {
				externalImprovement = thisImprovement.toFixed(1);
			}
			
		}
		
		if(isNaN(improvement) == false) {
		
			var startDateDate = startDate;
			var endDateDate = endDate;
			if(endDateDate && startDateDate && endDateDate.getTime() && startDateDate.getTime()) {
				var timeDiff = Math.abs(endDateDate.getTime() - startDateDate.getTime());
			} else {
				var timeDiff = 0;
			}
			var diffDays = Math.ceil(timeDiff / (1000 * 3600 * 24)); 
			
			
			
			if(isNaN(diffDays) == false) {
				if(diffDays > 6) {
			
					if(diffDays > 60) {
						var timeDiff = Math.floor(diffDays / 30) + " months and " + diffDays % 30 + " days";
					} else {
						var timeDiff = Math.floor(diffDays / 7) + " weeks";
					}
		
				} else {
					
				
					if(diffDays == 1) {
						var timeDiff = diffDays + " day";
					} else {	
						var timeDiff = diffDays + " days";
					}	
				}
		
		
				var showColour = "panel-warning";
		
				if((improvement < 30)&&(diffDays > 14)) {
					showColour = "panel-red";		//Make the warning red								
				}
			
				if(improvement < 0) {
					showColour = "panel-red";		//Make the warning red	
				}
		
				if(improvement >= 97) {
					showColour = "panel-success";
				}
				
				if(startUnderSize) {
					//Handle undermining
					underminingStr = "<br/><span style='color:#888;'>External " + externalImprovement + "% Undermining " + underImprovement + "%</span>";
				
				}
		
				output.showColour = showColour;
				output.improvement = improvement.toFixed(1);		//Output as a string
				output.timeDiff = timeDiff;
				output.underminingStr = underminingStr;
				
			} else {
				//Unknown time period
				
				var showColour = "panel-warning";
			
				if(improvement < 0) {
					showColour = "panel-red";		//Make the warning red	
				}
		
				if(improvement >= 97) {
					showColour = "panel-success";
				}

				output.showColour = showColour;
				output.improvement = improvement.toFixed(1);		//Output as a string
				output.timeDiff = timeDiff;
				output.underminingStr = underminingStr;
				
			
			}
		} else {
		
			output.showColour = "panel-warning";
			output.fullMsg = "The wound improvement rate is unknown.  " + underminingStr;
		}	
		
   } else {
   		output.showColour = "panel-warning";
		output.fullMsg = "The wound improvement rate is unknown.  " + underminingStr;

   }
 
   return output; 
}




function outputDirectoryHTML(inpath, htmlcb, isDirectory, sessionId, style, dirPhotoVersion, cacheConfigLocally, globalConf) {
	//Reads through a directory, gets all of the photos in thumbnail format, and the filenames and areas,
	//and display them in a grid. Each image is clickable and will run to the full-page analysis.
	
	
	
	readConfig(masterConfigFile, function(conf, err) {
		if(err) {
			//There was a problem loading the master config
			console.log("Error reading master config file:" + err);
			conf = {};
		}
		


		var items = [];
		var htmlList = [];
		var outputHTML = "<table>";

		if(verbose == true) console.log("Path incoming:" + inpath);


		//Get the return path for coming back to this screen again
		var retPath = normalizeInclWinNetworks(inpath, "winstyle");
		if(verbose == true) console.log("Return path: " + retPath);
		if(verbose == true) console.log("Removing from return path 1: " + __dirname);
		retPath = retPath.replace(__dirname, "");

		var norm = normalizeInclWinNetworks(mainMedImagePath + "/", "winstyle");
		if(verbose == true) console.log("Removing from return path 2: " + norm);
		retPath = retPath.replace(norm,"");

		if(verbose == true) console.log("Removing from return path 3: " + medPhotosRelativePath);
		retPath = retPath.replace(medPhotosRelativePath,"");



		if(verbose == true) console.log("Return path now: " + retPath);


		if(isDirectory == true) {	
			//Get all jpg files in this dir
			var thispath = normalizeInclWinNetworks(inpath + "/*.*", "winstyle");		//Was *.jpg, but we also want to include subdirectories
		} else {
			//Get all files starting with this text
			var thispath = normalizeInclWinNetworks(inpath + "*.jpg", "winstyle");
		}	
		if(verbose == true) console.log("Directory: " + __dirname);
		thispath = thispath.replace(__dirname, "");
		var searchPath = normalizeInclWinNetworks(resolve(thispath));
		if(verbose == true) console.log("Searching path=" + searchPath);			//Note: the parent script just needs photos/path/here/
		
		var myStyle = style;
	
		myGlob(searchPath, function(err, items) {
				if(err) {
					console.log("Error: " + err);
					return;
				
				} else {
					  if(verbose == true) console.log("Items: " + JSON.stringify(items, null, 2));
			 
			  
			   
					  async.eachOf(items,
						  // 2nd param is the function that each item is passed to
						  function(item, ind, callback){
				  
					
							htmlList[ind] = {
								"html": ""
							};
					
				  
					
							// Call an asynchronous function, often a save() to DB
							if(item.indexOf(thumbnailString) >= 0) {
								//Definitely a .jpg thumbnail image file
								//Append to the list of user options to select
								var rootFilename = item.replace(thumbnailString + "jpg","");
								
								if(winSharedDrive == true) {
									//Add a shared drive if applicable
									rootFilename = targetDrive + rootFilename;
								}
								
								
								
								
						
								if(verbose == true) console.log("Root filename=" + rootFilename);
								rootFilename = normalizeInclWinNetworks(rootFilename);
						
								if(verbose == true) console.log("Root filename after replacing=" + rootFilename);
						
												
								var rootPicname = afterStr(rootFilename,imagesStart);	//Get rid of any ./photos
								if(verbose == true) console.log("Root picname=" + rootPicname);
						
								rootPicname = trimChar(rootPicname,'/');
						
								if(verbose == true) console.log("Root picname=" + rootPicname);
						
								var confName = rootFilename + ".json";
					
								if(verbose == true) console.log("Loading config:" + confName);
					
								//If we are using a shared drive, we need to cache all of the thumbnails locally at this stage
								if(cacheConfigLocally == true) {
									var cacheLocalConfigFile = path.resolve(__dirname + "/" + relImagePath + "/" + rootPicname + ".json");
									console.log("Cache testing target:" + confName + "  local version: " + cacheLocalConfigFile);
									cacheLocally(null, cacheLocalConfigFile, dirPhotoVersion, confName, true);
								
								}
					
						
					
								//Load up the config file
								readConfig(confName, function(conf, err) { 
									//Have loaded this config file up
									if(err) {
										console.log('ERR:' + err);
										//Most likely a missing json file.
										var thisArea = "[Not found]";
										var newHTML = "<tr><td><p><a href='/addon/show-analysis?photo=" + rootPicname + ".jpg&ret=" + retPath + "&sessionId=" + sessionId + "'><img src='/addon/show-photo?p=" + rootPicname + thumbnailString + "jpg&sessionId=" + sessionId + "' style='width: 300px; height: 200px;'></a><br/><a href='/addon/show-analysis?photo=" + rootPicname + ".jpg&ret=" + retPath + "&sessionId=" + sessionId + "'><b>" + rootPicname + "</b></a>&nbsp;<i class='fa fa-pie-chart'></i>&nbsp;" + thisArea + "&nbsp;cm<sup>2</sup>[MORE]</p></td></tr>";
										if(verbose == true) console.log(newHTML);
										htmlList[ind].html = newHTML;
										htmlList[ind].dir = false;
								
										callback();
									} else {
							
								
										var underminingStr = "";
										if((conf)&&(conf.output)&&(conf.output.fullWound)) {
											var thisArea = conf.output.fullWound.areaSquareCm;
									
											//Get the wound size stored
											if(isNaN(thisArea) == false) {
												htmlList[ind].woundSize = thisArea;
											}
									
											//Handle undermining
											if(conf.output.fullWound.underAreaSquareCm) {
												var externalArea = conf.output.fullWound.woundAreaSquareCm;
												var underArea = conf.output.fullWound.underAreaSquareCm;
										
												underminingStr = "<span style='color:#888;'>";
										
												if(isNaN(externalArea) == false) {
													htmlList[ind].externalSize = externalArea;
													underminingStr += "&nbsp;<i class='fa fa-pie-chart'></i> External " + externalArea + "&nbsp;cm<sup>2</sup>";
											
												}
										
												if(isNaN(underArea) == false) {
													htmlList[ind].underSize = underArea;
													underminingStr += "&nbsp;<i class='fa fa-pie-chart'></i> Undermining " + underArea + "&nbsp;cm<sup>2</sup>";
												}
										
												underminingStr += "</span>";
										
											} 
									
										} else {
											var thisArea = "[Sticker is undetected]";
										}
										
										//Add a direct mobile link if appropriate
										var linkToStyle = "";
										if(myStyle == "mob") {
											linkToStyle = "&style=mob";	
										}
								
										var newHTML = "<tr><td><p><a class='refresh-links' href='/addon/show-analysis?photo=" + rootPicname + ".jpg&ret=" + retPath + "&sessionId=" + sessionId + linkToStyle + "'><img class='refresh-me' src='/addon/show-photo?p=" + rootPicname + thumbnailString + "jpg&sessionId=" + sessionId + "' style='width: 300px; height: 200px;'></a><br/><a class='refresh-links' href='/addon/show-analysis?photo=" + rootPicname + ".jpg&ret=" + retPath + "&sessionId=" + sessionId + linkToStyle + "'><b>" + rootPicname + "</b></a>&nbsp;<i class='fa fa-pie-chart'></i>&nbsp;" + thisArea + "&nbsp;cm<sup>2</sup>[MORE]" + underminingStr + "</p></td></tr>";
										 if(verbose == true) console.log(newHTML);
										 htmlList[ind].html = newHTML;
										 htmlList[ind].dir = false;
								 
										 //Now get the main photo file creation time on disk
										 var origPhotoFile = rootFilename + ".jpg";
										 fs.stat(origPhotoFile, function(err, stats){
											if(stats) {
												var mtime = new Date(stats.mtime);
												htmlList[ind].date = createDateAsUTC(mtime);
												callback();
											} else {
												callback();
											}
										 });
								 
								 
									}
						
							
								});
					
							} else {
					
							   //Not an image thumbnail. Check if a directory - we still want to display these
							   var rootFilename = item;
					   
							   //Check if a directory
								fs.lstat(item, (err, stats) => {

									if(err) {
										 console.log("Error reading file:" + err);
									}
									if((stats) && (stats.isDirectory())) {
										//A directory - display this at the top
								
										if(verbose == true) console.log("Root dirname=" + rootFilename);
										rootFilename = normalizeInclWinNetworks(rootFilename);
						
										if(verbose == true) console.log("Root dirname after normalizing=" + rootFilename);
										var rootDirname = afterStr(rootFilename,imagesStart);	//Get rid of any ./photos
										if(verbose == true) console.log("Root dirname=" + rootDirname);
								
										rootDirname = trimChar(rootDirname,'/');
								
										if(verbose == true) console.log("Root dirname=" + rootDirname);
								
								
										//Add a direct mobile link if appropriate
										var linkToStyle = "";
										if(myStyle == "mob") {
											linkToStyle = "&style=mob";	
										}
								
										var newHTML = "<tr><td><p><b><a href='/addon/show-analysis?photo=" + rootDirname + "&ret=" + retPath + "&sessionId=" + sessionId + "'><i class='fa fa-folder fa-3x' style='vertical-align: middle;'></i></a>&nbsp;&nbsp;<a href='/addon/show-analysis?photo=" + rootDirname + "&ret=" + retPath + "&sessionId=" + sessionId + linkToStyle + "'>" + rootDirname + " [Subfolder]</a></b></p></td></tr>";
										 if(verbose == true) console.log(newHTML);
										 htmlList[ind].html = newHTML;
										 htmlList[ind].dir = true;
				
										 var mtime = new Date(stats.mtime);
										 htmlList[ind].date = createDateAsUTC(mtime);		//Folders creation time
								
								
									}
							
									//Must complete the callback regardless
									callback();
								});
					
							}
					
					
					
						  },
						  // 3rd param is the function to call when everything's done
						  function(err){
							// All tasks are done now
							if(err) {
							   console.log('ERR:' + err);
							 } else {
							   console.log('Completed all entries!');
					   
					   
					   
					   
							   //Filter out unneeded results
							   var goodHTMLList = [];
					   
							   //Filter out blank values
							   for(var cnt=0; cnt < htmlList.length; cnt++) { 
									if(htmlList[cnt].html != "") {
										goodHTMLList.push(htmlList[cnt]);
														
									}
							   }
					   
					
							   //Sort into ascending date order
							   goodHTMLList.sort(function(a,b){
									// Turn your strings into dates, and then subtract them
									// to get a value that is either negative, positive, or zero.
									return new Date(a.date) - new Date(b.date);
								});
					   
					  
						
						
							   var first = true;
							   var startWoundSize = null;
							   var endWoundSize = null;
							   var startDate = null;
							   var endDate = null;
					   
							   var startUnderSize = null;
							   var endUnderSize = null;
							   var startExternalSize = null;
							   var endExternalSize = null;
					   
							   var lastImprovement = 0;
			  
							   //Go from start to end
							   for(var cnt=0; cnt < goodHTMLList.length; cnt++) { 
							
									//Now we are in the correct date order, we can calculate the start to finish improvements
									if(goodHTMLList[cnt].woundSize) {
										if(first == true) {
											startWoundSize = goodHTMLList[cnt].woundSize;
											endWoundSize = goodHTMLList[cnt].woundSize;
											startDate = goodHTMLList[cnt].date;
											endDate = goodHTMLList[cnt].date;
									
											if(goodHTMLList[cnt].underSize) {
												//Handle undermining
												startUnderSize = goodHTMLList[cnt].underSize;
												endUnderSize = goodHTMLList[cnt].underSize;
												startExternalSize = goodHTMLList[cnt].externalSize;
												endExternalSize = goodHTMLList[cnt].externalSize;
											}
									
											goodHTMLList[cnt].html = goodHTMLList[cnt].html.replace("[MORE]", ""); 
									
											first = false;
										} else {
											//Not the first
											endWoundSize = goodHTMLList[cnt].woundSize;
											endDate = goodHTMLList[cnt].date;
									
									
									
											if(goodHTMLList[cnt].underSize) {
												//Handle undermining
												endUnderSize = goodHTMLList[cnt].underSize;
												endExternalSize = goodHTMLList[cnt].externalSize;
											}
									
									
											var improve = calcImprovement(outputHTML, startWoundSize, endWoundSize, startDate, endDate, startUnderSize, endUnderSize, startExternalSize, endExternalSize);
											var newImprovement = -(improve.improvement - lastImprovement);
											newImprovement = newImprovement.toFixed(1); 
											if(newImprovement > 0) newImprovement = "+" + newImprovement;
											newImprovement = " <span style='color: #aaa;'>(" + newImprovement + "%)</span>";
											goodHTMLList[cnt].html = goodHTMLList[cnt].html.replace("[MORE]", newImprovement);
											lastImprovement = improve.improvement;
									
										}
									} else {
										//No wound size
										goodHTMLList[cnt].html = goodHTMLList[cnt].html.replace("[MORE]", "");
									}
							
							   }
					   
								//Do in reverse order
							   goodHTMLList.reverse();
					   
							   //Go from end to start visually
							   for(var cnt=0; cnt < goodHTMLList.length; cnt++) { 
									if(goodHTMLList[cnt].html != "") {
										outputHTML += goodHTMLList[cnt].html;						   		
									}
							   }
					   
					   
							   outputHTML += "</table>";		//Closing table
					   
							   //Now show the % improvement. E.g. if a wound started out being 4.5 sqcm, and becomes
							   //1.9 sqcm, the percent improvement would be ((4.5 - 1.9) / 4.5) * 100 = 57% improvement
							   outputHTML = displayCalcImprovement(outputHTML, startWoundSize, endWoundSize, startDate, endDate, startUnderSize, endUnderSize, startExternalSize, endExternalSize);  //Put this at the start visually
							   outputHTML += "</p>";
					   
					   
							   messaging = "display: none;";
							   var ajServer = "";
							   var ajForum = "";
							   var ajGlobalForum = "";
							   var ajCSS = "https://frontcdn.atomjump.com/atomjump-frontend/comments-1.0.4.css";
							   var ajJS = "https://frontcdn.atomjump.com/atomjump-frontend/chat-1.1.1.js";
							   var ajBaseCSS = "https://frontcdn.atomjump.com/atomjump-frontend/bootstrap.min.css";
							   var ajMachineUser = "192.104.113.117:8";
							   var ajDomain = "";			//If we want to match domains for same origin policy
							   						//https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy
							   if(conf && conf.output && conf.output.ajServer) {
									ajServer = decodeURIComponent(conf.output.ajServer);
					   
								   var fullPath = normalizeInclWinNetworks(dirPhotoVersion, "winstyle")
								   if(verbose == true) console.log("Root dirname=" + fullPath);									
								   rootDirname = trimChar(fullPath,'/');
								   rootDirname = rootDirname.replace("\\", "/");
								   rootDirname = rootDirname.replace(/[^\/\.a-z0-9]/ig, '-');	//Replace any weird chars with hyphens
					   
								   if(conf.output.ajRoot) {
										ajForum = decodeURIComponent(conf.output.ajRoot) + rootDirname;
										ajGlobalForum = decodeURIComponent(conf.output.ajRoot);
								   }
								   
								   if(conf.output.ajCSS) {
										ajCSS = decodeURIComponent(conf.output.ajCSS);
								   }
								   if(conf.output.ajJS) {
										ajJS = decodeURIComponent(conf.output.ajJS);
								   }
								   if(conf.output.ajBaseCSS) {
										ajBaseCSS = decodeURIComponent(conf.output.ajBaseCSS);
								   }
								   if(conf.output.ajMachineUser) {
										ajMachineUser = decodeURIComponent(conf.output.ajMachineUser);
								   }
								   if(conf.output.ajDomain) {
								   		ajDomain = decodeURIComponent(conf.output.ajDomain);
								   }
								   								   							   
							   }
							   
							   
							
						   				
					   
					   		
					   		   //Mobile or desktop version of the page
					   		   if(myStyle == "mob") {
					   		       var newLocation = "mob-photo-list.html";
					   		   	   messaging = "display: none;";
					   		   		
					   		   		
					   		   	   var pairLink = "/pair?country=NZ&style=aj";		//Default link
								   var connectStyle = "aj";								//Default style
								   var countryCode = "NZ";							//Default pairing country
								   var proxy = "";
			   
								   if(globalConf.style) {
										connectStyle = globalConf.style;
								   }
			   
								   switch(connectStyle) {
			   
										case "aj":
											  if(globalConf.countryCode) {
													pairLink = "/pair?country=" + globalConf.countryCode + "&style=aj";
											  }
										break;
					
										case "private":
											 if(globalConf.proxy) {
													pairLink = "/pair?proxyServer=" + encodeURIComponent(globalConf.proxy) + '&style=private';
											 }
										break;
					
										default:
												//Keep the default
										break;
								   }
			   
								   pairLink = encodeURIComponent(pairLink);		//Must be encoded, because otherwise, the 'style' param gets confused
					   		   		
					   		   		
					   		   } else {
					   		   		var newLocation = "photo-list.html";
					   		   		
					   		   		var pairLink = "";
								
					   		   }
					   			
							   console.log("returnParams:?CHANGELOCATION=" + newLocation + "&CUSTOMGRID=" + encodeURIComponent(outputHTML) + "&TEXTENTERED=" + retPath + "&MESSAGING=" + messaging + "&AJSERVER=" + ajServer + "&AJFORUM=" + ajForum + "&AJGLOBALFORUM=" + ajGlobalForum + "&AJCSS=" + ajCSS + "&AJJS=" + ajJS + "&AJBASECSS=" + ajBaseCSS + "&AJMACHINEUSER=" + ajMachineUser + "&AJDOMAIN=" + ajDomain + "&PAIRLINK=" + pairLink + "&SESSIONID=" + sessionId);
							   htmlcb();
							 }        
						  }
						);

			  
				 }  			 
			
			
			
			});

	}); //End of read master config
		

}


function cacheFile(fromFile, toFile) {
		//Returns 'true' for copied OK, 'false' for error
		
		try {
			
			var data = fs.readFileSync(fromFile);
		} catch (err) {
			console.log("Sorry, cannot read file! " + fromFile + "  Error:" + err);
			return false;
		}	
		
		
		try {
			fs.writeFileSync(toFile,data);
		} catch (err) {
			console.log("Sorry, cannot write file! " + toFile + "  Error:" + err);
			return false;
		}	
		
		return true;
}


function cacheLocally(conf, cacheLocalConfigFile, dirPhotoVersion, readConfigFile, justThumbnail) {
 	 
 	 //conf is the files config file as an object - if it is already loaded. If not, it will be loaded.
 	 //readConfigFile is the target folder config file
 	 //cachLocalConfigFile is the C:/medimage/photos version of the same
 	 //dirPhotoVersion is the folder within the photo directory e.g. "/IMAGE/mypic-datetime.jpg"
 	 //justThumbnail = true for only the thumbnail being cached. Is false for all versions of the file.
 	 
 	 //Create the folder if required also
 	 
 	 if(!conf) {
 	 	//Load up the remote config
 	 	try {
 	 		var data = fs.readFileSync(readConfigFile);
 	 		try {
				conf = JSON.parse(data);
				
				//console.log("Read in config:" + JSON.stringify(conf, null, 6));
			} catch (err) {
				console.log("Sorry, cannot read config file! " + readConfigFile + "  Error:" + err);
				return;
			}	
 	 	} catch(err) {
 	 		console.log("Error reading target folder config file during a local caching attempt: " + readConfigFile + "  Error");
 	 		return;
 	 		
 	 	}
 	 }
 	 
 	 
 	 
 	 var localDirname = path.resolve(__dirname + "/" + relImagePath + "/" + dirPhotoVersion);
 	 console.log("Trying to create a cached folder: " + localDirname);
 	 try {
 	 	fsExtra.ensureDirSync(localDirname);
 	 } catch(err) {
 	 	console.log("Error: Could not create the correct local directory: " + err);
 	 	return;
 	 }
 	 
 	 try {
 	 	fs.writeFileSync(cacheLocalConfigFile, JSON.stringify(conf, null, 6));
 	 } catch(err) {
 	 	console.log("Error writing target folder config file during a local caching attempt: " + cacheLocalConfigFile);
 	 	
 	 }
	 	
								
	//Also cache the other photo files
	
	
	var nameConvention = conf.output.scaledPhoto.nameConvention;
	

	//Don't enter any console messages here - will disrupt the final export
	//E.g. console.log("Copying " + copyFrom + " to " + copyTo);

	//Thumbnail copy	
	var copyFrom = readConfigFile.replace(".json", nameConvention.withThumbnailText);
	var copyTo = cacheLocalConfigFile.replace(".json", nameConvention.withThumbnailText);

	cacheFile(copyFrom, copyTo);
	
	if(justThumbnail == false) {		//Ignore the other larger files
	
		//Source jpg copy
		var copyFrom = readConfigFile.replace(".json", ".jpg");
		var copyTo = cacheLocalConfigFile.replace(".json", ".jpg"); 
		cacheFile(copyFrom, copyTo);

		//Webview copy - will do this last one in sync
		var copyFrom = readConfigFile.replace(".json", nameConvention.withWebViewText);
		var copyTo = cacheLocalConfigFile.replace(".json", nameConvention.withWebViewText);
		cacheFile(copyFrom, copyTo);
	}
	
	return;
}
								



if(process.argv[2]) {

	//Incoming get requests are in normal "var=value&var2=value" format urlencoded

	var opts = queryString.parse(decodeURIComponent(process.argv[2]));

	if(verbose == true) console.log("opt:" + JSON.stringify(opts));		

	var dirPhotoVersion = opts.photo.replace(" ","/");	
	if(dirPhotoVersion[0] == '/') {
			dirPhotoVersion = dirPhotoVersion.substr(1);	//Remove any '/'s at the start
	}			
	
	//Write this array into the range calculation in the config file
	var cacheLocalConfigFile = __dirname + "/" + relImagePath + "/" + dirPhotoVersion.replace(".jpg", ".json");
	
	
	
	if(verbose == true) console.log("config file:" + cacheLocalConfigFile);		

	var sessionId = "";
	if(opts.sessionId) {
		sessionId = opts.sessionId;
	}
		
	readConfig(globalConfigFile, function(conf, err) {
		if(err) {
			//There was a problem loading the master config
			console.log("Error reading master config file:" + err);
		} else {
			//Rearrange default paths to the output folder
			rearrangePaths(conf);
			
			if(conf.backupTo && conf.backupTo[0]) {
				//By default use the destination version, since that is shared
				readConfigFile = nonRelativeMedImagePath + "/" + dirPhotoVersion.replace(".jpg", ".json"); 
			} else {
				//Otherwise use the local version
				readConfigFile = cacheLocalConfigFile;
			}
			
		
			//Check the config of the file itself
			fs.lstat(readConfigFile, (err, stats) => {

				var cacheConfigLocally = false;		//If we use a remote version of the file, we want to write the config file locally once it is loaded, as a local cache
				 //Check if we are using a destination folder don't have a local version
				 // i.e. a different user has entered something. But also copy it for local changes. Remote
				 //changes may have been completed by someone else, so it usually always needs to be copied
				 if(conf.backupTo && conf.backupTo[0]) {
						 cacheConfigLocally = true;
					 					 
				 }
				
				if(err) {
					 console.log("Error reading config file:" + err);
					 
					//Continue on anyway, without the specific config file - but use the master config
					readConfigFile = masterConfigFile;
					console.log("Using master config file:" + masterConfigFile);
					 	
				}
				
				
		
		
				if((stats) && (stats.isDirectory())) {
					console.log("Display the whole directory.");
					outputDirectoryHTML(mainMedImagePath + "/" + dirPhotoVersion, function(err) {
						if(err) {
						} else {
						}
					}, true, sessionId, opts.style, dirPhotoVersion, cacheConfigLocally, conf);		//true means a directory
		 
				} else {
			
					if(!stats) {
						
						//We need to get photos starting with this in the directory
						outputDirectoryHTML(mainMedImagePath + "/" + dirPhotoVersion, function(err) {
							if(err) {
							} else {
							}
						}, false, sessionId, opts.style, dirPhotoVersion, cacheConfigLocally, conf);		//false means a file
					} else {
			
						//Assume a file - simple case
						console.log("Reading as a file.");
			
						//Display the return parameters
						readConfig(readConfigFile, function(conf, err) {

						   if(err) {
							 //There was a problem loading the config
							 console.log("Error reading config file:" + err);
				 
							 var area = "[Unknown area]";
				 
							 var rawImage = opts.photo;
					 
					 		 var areas = "[]";
					 		 
					 
							 var returnLink = "";
							 if(opts.ret) {
								returnLink = opts.ret;
							 }
					 
							 var woundPhotoFile = dirPhotoVersion.replace(replaceText, withWebViewText);	//Note: changing to web view on purpose. There may be no wound photo view.
							 
							 //Mobile or desktop version of the page
					   		   if(opts.style == "mob") {
					   		   		var newLocation = "CHANGELOCATION=mob-photo-analysis.html&";
					   		   } else {
					   		   		var newLocation = "";
					   		   }
							 
							 console.log("returnParams:?" + newLocation + "CUSTOMAREA=" + area + "&CUSTOMIMAGE=" + rawImage + "&CUSTOMWOUNDIMAGE=" + woundPhotoFile + "&AREAS=" + areas + "&RETLINK=" + returnLink + "&SESSIONID=" + sessionId);
				 
						   } else {
						   	
						   	  //Read config successfully
						   	  if(cacheConfigLocally == true) {
						   	  	 //Write a cached version of the config file in our local photos folder for ready access
						   	  	 
						   	  	 cacheLocally(conf, cacheLocalConfigFile, path.dirname(dirPhotoVersion), readConfigFile, false);
						   	  	 
						   	  	 
						   	  } 
						   
						   
							   if((conf) && (conf.output) && (conf.output.fullWound) && (conf.output.fullWound.areaSquareCm)) {
									var area = conf.output.fullWound.areaSquareCm;
							   } else {
									//OK, so we have a config, but the area is not set
									var area = "[Unknown area]";
									
							   }
							   
							  if((conf) && (conf.output) && (conf.output.fullWound) && (conf.output.fullWound.underAreaSquareCm)) {
							  		
							  		var woundArea = conf.output.fullWound.woundAreaSquareCm;
							  		var underminingArea = conf.output.fullWound.underAreaSquareCm;
							   		var underminingAreaStr = ".<span style=\"color: #888;\"> External <i class=\"fa fa-pie-chart\"></i>  <span id=\"total-area\">" + woundArea + "</span> cm<sup>2</sup>.  Undermining <i class=\"fa fa-pie-chart\"></i>  <span id=\"total-area\">" + underminingArea + "</span> cm<sup>2</sup></span>";
							   } else {
							   		var underminingAreaStr = "";
							   }
							   
							   
							   //Check if we want to display the sticker version instead of the default wound version
							   var startWith = "wound";
							   if((conf) && (conf.output)) {
							   		if(!conf.output.stickerSquarePixels) {		//Either 0 or not existing
							   			startWith = "sticker";
							   		}
							   } else {
							   		startWith = "sticker";
							   }
							   
							   if(opts.startWith == "sticker") {
							   		startWith = "sticker";
							   }
							   
							   
				   
							   //Change the interface to either auto-wound detection or auto drawing
							   if((conf) && (conf.input) && (conf.input.wound)) {
									if(conf.input.wound.autoWoundDetection == true) {
										var woundDetect = "true";
									} else {
										var woundDetect = "false";
									}
							   } else {
									var woundDetect = "true";
							   }
					   
					   		   if(conf && conf.output && conf.output.areas) {
								 var areas = encodeURIComponent(JSON.stringify(conf.output.areas));
							   } else {
								 var areas = "[]";
							   }
					
					   
							  var returnLink = "";
							  if(opts.ret) {
								 returnLink = opts.ret;
							  }
					  
					  		   //Display wound type classification
							   var startWoundType = "Unclassified";
							   if((conf) && (conf.output)) {
									if(conf.output.woundType) {		
										startWoundType = conf.output.woundType;
									} 
							   }
					  
			   
			   
							   var rawImage = dirPhotoVersion;
							   var woundPhotoFile = dirPhotoVersion.replace(conf.output.scaledPhoto.nameConvention.replaceText, conf.output.scaledPhoto.nameConvention.withWebViewText);
							   
							   //Mobile or desktop version of the page
					   		   if(opts.style == "mob") {
					   		   		var newLocation = "CHANGELOCATION=mob-photo-analysis.html&";
					   		   } else {
					   		   		var newLocation = "";
					   		   }
							   
							   
							   console.log("returnParams:?" + newLocation + "CUSTOMAREA=" + area + "&CUSTOMIMAGE=" + rawImage + "&CUSTOMWOUNDIMAGE=" + woundPhotoFile + "&AREAS=" + areas + "&CUSTOMWOUNDDETECT=" + woundDetect + "&CUSTOMSTARTWITH=" + startWith + "&CUSTOMWOUNDTYPE=" + startWoundType + "&RANDIMAGE=" + Date.now() + "&RETLINK=" + returnLink + "&UNDERMININGAREA=" + underminingAreaStr + "&SESSIONID=" + sessionId);
							}
						});
					}
				}
		

			});

		
		
		}  //end of master else
	});  //end of master read
	
	
	
		


} else {
	

	console.log("Usage: node show-wound-size.js file/path/photo.jpg");


}

