/*

MedImage Wound Analysis Add-on - Display area
==============================

Developed by (C) AtomJump Ltd. 10 Aug 2017. This is a commercial add-on to MedImage, and is licensed
by AtomJump on a per-server basis.

This script will display an input photo.

Should be called with /addon/show-photo?p=/path/to/photo.jpg&session=abcdefgh-dfhdkja

*/


var fs = require('fs');
var upath = require('upath');
var path = require('path');
var queryString = require('querystring');

var session = require('../basic-authentication/session.js');


var masterConfigFile = __dirname + '/config/master.json';
var mainMedImagePath = "../../photos/";		//This should remain relative
var mainServerImagesPath = "../../public/images/";		//This should remain relative
var processRelativeMedImagePath = "../../MedImage/photos/";		//This should remain relative

var verbose = false;


//Include shared funcs
var readConfig = require(__dirname + '/common/libfuncs.js').readConfig;

function cacheFile(fromFile, toFile) {
		//Returns 'true' for copied OK, 'false' for error
		if(verbose == true) console.log("Cur dir:" + process.cwd() + "   From file: " + fromFile + " To file: " + toFile);
		try {
			
			var data = fs.readFileSync(fromFile);
		} catch (err) {
			console.log("Sorry, cannot read file! " + fromFile + "  Error:" + err);
			return false;
		}	
		
		
		try {
			fs.writeFileSync(toFile,data);
		} catch (err) {
			console.log("Sorry, cannot write file! " + toFile + "  Error:" + err);
			return false;
		}	
		
		return true;
}

function getRandomInt(min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min + 1)) + min;
}



module.exports = { 
	medImage : function(argv, callback) {

		
		   var param = decodeURIComponent(argv[0]);
		   var opts = queryString.parse(param);	
			
		   if(session.checkSessionValid(opts.sessionId) > -1) {
 				//We have permission to show photo
			   
				//Check if global config overrides path
				
				//Only want the final photo version.
					//However, we don't mind using a different version on the same drive
					if(globalConfig.backupTo && globalConfig.backupTo[0] && opts.original && opts.original === "true") {
					            //TODO: WARNING check security on this - should not be allowed to access random path!
								var tempMainMedImagePath = upath.relative(process.cwd(),globalConfig.backupTo[0]); 
								var incomingPhotoFile = tempMainMedImagePath + "/" + opts.p; 
								var randNum = getRandomInt(0,10);
								var writeFile = processRelativeMedImagePath + "/cache/photo" + randNum + ".jpg";
								
								//Create the directory
								var dir = processRelativeMedImagePath + "/cache";
								if (!fs.existsSync(dir)){
									fs.mkdirSync(dir);
								}
								
								var writePhotoFile = upath.relative(process.cwd(), writeFile);
								cacheFile(incomingPhotoFile, writePhotoFile);
																
								var readPhotoFile = mainMedImagePath + "/cache/photo" + randNum + ".jpg";
						} else {
					    var readPhotoFile = mainMedImagePath + "/" + opts.p; 
					}
				
				
				
				  
				
				

			   //Your code in here, which sets 'resp'. The output is up to you.
				var output =  "returnPhotoFile:" + readPhotoFile;
				if(verbose == true) console.log(output);

				var ret = {};
				ret.err = null;
				ret.stdout = output;
				ret.stderr = null;
			
				//Always return { err, stdout, stderr }. Include an error in the first param if necessary.
				callback(null, ret);	
		   } else {
		   		//Not logged in - don't show any photo, other than a login photo
		   		var output = "returnPhotoFile:" + mainServerImagesPath + "please-login.png";
		   		
		   		var ret = {};
				ret.err = null;
				ret.stdout = output;
				ret.stderr = null;
			
				//Always return { err, stdout, stderr }. Include an error in the first param if necessary.
				callback(null, ret);	
		   
		   }
	
	}	
}	


