/*

MedImage Wound Analysis Add-on - Display colour adjustment
==============================

Developed by (C) AtomJump Ltd. 10 Aug 2017. This is a commercial add-on to MedImage, and is licensed
by AtomJump on a per-server basis.

This script will read a given photo, and display the colour adjustment page of that photo.
It will show the colour ranges available for the detection of both the stickers and the wounds.

*/


var fs = require('fs');
var fsExtra = require('fs-extra');
var upath = require('upath');
var path = require('path');
var queryString = require('querystring');

var verbose = false;


var masterConfigFile = __dirname + '/config/master.json';
var globalConfigFile = __dirname + '/../../config.json';
var mainMedImagePath = "../../photos";
var relImagePath = "../../photos";		//relative to this script
var nonRelativeMedImagePath = __dirname + '/' + relImagePath;
var imagesStart = "/photos";				//

var normalizeInclWinNetworks = require(__dirname + '/common/libfuncs.js').normalizeInclWinNetworksStyle;



var replaceText = ".jpg";					//The default values from the master config - to be used when we can't load the config for some reason
var withWebViewText =  ".web-view.jpg";		//The default values from the master config - to be used when we can't load the config for some reason

var blankConf = {
				 	"input": {
				 		"wound": {
				 			"colourRanges" : []
				 		},
				 		"sticker": {
				 			"colourRanges" : []
				 		}
				 	}
				 };




function readConfig(confFile, cb) {
	//Reads and updates config with a newdir in the output photos - this will overwrite all other entries there
	//Returns cb(err) where err = null, or a string with the error


	//Write to a json file with the current drive.  This can be removed later manually by user, or added to
	fs.readFile(confFile, function read(err, data) {
		if (err) {
				cb(null, "Sorry, cannot read config file! " + err);
		} else {
			if(data) {
				try {
					var content = JSON.parse(data);
				} catch (err) {
					cb(null, "Sorry, cannot read config file! " + err);
					return;
				}	
				
			} else {
				var content = null;
			}
			
			
			cb(content, null);
		};
	});

}


//Note: difference here from some versions of this func is we do have the master config loaded. So we will do that below and modify the default paths

function rearrangePaths(globalConfig) {
		
		//Relative to this script
		if(globalConfig.backupTo && globalConfig.backupTo[0]) {
			
		
			//And imagesStart, which is relative to the current server directory
			/* OLD way before only keeping on C:\MedImage\photos
			var platform = process.platform;
			var isWin = /^win/.test(platform);
			if(isWin) {
				imagesStart = normalizeInclWinNetworks(path.relative(process.cwd(),globalConfig.backupTo[0]));	
				mainMedImagePath = path.relative(process.cwd(), globalConfig.backupTo[0]);
				nonRelativeMedImagePath = globalConfig.backupTo[0];	 
			} else {
				imagesStart = globalConfig.backupTo[0];
				mainMedImagePath = path.relative(process.cwd(), globalConfig.backupTo[0]);	
				nonRelativeMedImagePath = globalConfig.backupTo[0];	 
			}
			*/
		
		
			if(verbose == true) console.log("mainMedImagePath:" + mainMedImagePath);
			if(verbose == true) console.log("imagesStart:" + imagesStart);
		}
		
		return;
}



/* accepts parameters
 * h  Object = {h:x, s:y, v:z}
 * OR 
 * h, s, v
 Frpom: https://stackoverflow.com/questions/17242144/javascript-convert-hsb-hsv-color-to-rgb-accurately
 This code expects 0 <= h, s, v <= 1, if you're using degrees or radians, remember to divide them out.

 The returned 0 <= r, g, b <= 255 are rounded to the nearest Integer. If you don't want this behaviour
 remove the Math.rounds from the returned object.
*/
function HSVtoRGB(h, s, v) {
    var r, g, b, i, f, p, q, t;
    if (arguments.length === 1) {
        s = h.s, v = h.v, h = h.h;
    }
    i = Math.floor(h * 6);
    f = h * 6 - i;
    p = v * (1 - s);
    q = v * (1 - f * s);
    t = v * (1 - (1 - f) * s);
    switch (i % 6) {
        case 0: r = v, g = t, b = p; break;
        case 1: r = q, g = v, b = p; break;
        case 2: r = p, g = v, b = t; break;
        case 3: r = p, g = q, b = v; break;
        case 4: r = t, g = p, b = v; break;
        case 5: r = v, g = p, b = q; break;
    }
    return {
        r: Math.round(r * 255),
        g: Math.round(g * 255),
        b: Math.round(b * 255)
    };
}



function prepColourPairs(conf, confType) {
 	//Now define the multiple colours for the output, as colour pairs (convert the HSV to RGB)
 	//confType is "photo" or "global"
			   
			   
	   var rangeTypes = [ conf.input.wound.colourRanges, conf.input.sticker.colourRanges ];
	   var rangeNames = [ "Wound", "Sticker" ];
	   var coloursHTML = "";
	   
	   for(r = 0; r < rangeTypes.length; r++) {
		   var rangeType = rangeTypes[r];
		   
		   if((rangeNames[r] == "Wound")&&(conf.input.wound.autoWoundDetection === false)) { 		//Can be undefined, which means 'true'
		   		
		   		//No longer shown: coloursHTML += "<div><br/><b>Wound Detection Off</b><br/><p>Switch on from the <a href='/addon/view-tab-settings?wound-tab'>settings</a>.</p></div>";
		   } else {
		   
		   
			   coloursHTML += "<div><br/><b>" + rangeNames[r] + "</b><br/>";
				
			   coloursHTML += "<table>";
	   
	   
			   for(var cnt = 0; cnt < rangeType.length; cnt++) {
				
					var classes = rangeNames[r] + "-id" + cnt + "-" + confType;
				
				
			
					var range = rangeType[cnt];
					if(range) {		//Ignore null entries
						var lowerHSV = range.lowerHSV;
						var upperHSV = range.upperHSV;
						var h = lowerHSV[0] / 179.0;
						var s = lowerHSV[1] / 255.0;
						var v = lowerHSV[2] / 255.0;
						var rgb1 = HSVtoRGB(h,s,v);
			
						coloursHTML += "<tr class='" + classes + "'><td style='padding-top:3px; padding-bottom:3px; width: 50px; height:36px;'><div style='padding: 4px; width: 100%; height: 30px; background-color: rgb(" + rgb1.r + "," + rgb1.g + "," + rgb1.b + "); color: white;'>From</div></td>";
			
			
						//Create rgb square code snippet to insert
			
						var h = upperHSV[0] / 179.0;
						var s = upperHSV[1] / 255.0;
						var v = upperHSV[2] / 255.0;
						var rgb2 = HSVtoRGB(h,s,v);
	   
						coloursHTML += "&nbsp;<td style='padding-top:3px; padding-bottom:3px; width: 50px; height:36px;'><div style='padding: 4px; width: 100%; height: 30px; background-color: rgb(" + rgb2.r + "," + rgb2.g + "," + rgb2.b + "); color: white;'>&nbsp;To&nbsp;</div></td>";
				
				
						//Now append the fine-tuning menu
				
				
						if(confType == "global") {
							copyIcon = "fa-copy";
							var copyTitle = "Copy this colour range into the individual photo's range"; 	
						} else {
							copyIcon = "fa-globe";  //Show a make global icon
							var copyTitle = "Make this colour range global, for all new photos"; 	
						}
				
						coloursHTML += "<td>&nbsp;<span class='fine-tune " + classes + "'><a class='btn btn-outline btn-default wound-options'><i class='fa fa-ellipsis-h'></i></a></span></td></tr><tr><td colspan='3'><div id='" + classes + "' class='fine-tuned' style='display: none;'><a title='" + copyTitle + "' href='javascript:' class='btn btn-outline btn-default wound-copy " + classes + "'><i class='fa " + copyIcon + "'></i></a> <a title='Delete this colour range' href='javascript:' class='btn btn-outline btn-default wound-delete " + classes + "'><i class='fa fa-trash-o'></i></a></div></td></tr>";
					}
			
			   }
			   
			   var classes = rangeNames[r] + "-idx-" + confType;
			   coloursHTML += "<tr><td><a href='javascript:' title='Group Colour Ranges' class='btn btn-outline btn-default group " + classes + "'><i class='fa fa-object-group'></i></a></td></tr></table></div>";		//Insert a button to merge the colour pairs
			}
	   }
	   
	   
	   return coloursHTML;
}
	   
	  






if(process.argv[2]) {

	//Incoming get requests are in normal "var=value&var2=value" format urlencoded

		var opts = queryString.parse(decodeURIComponent(process.argv[2]));		

		

	   readConfig(globalConfigFile, function(globalConfig, err) {

		   if(err) {
			 console.log("Error reading global config file:" + err);
			 //Set up some blanks
			 globalConfig = blankConf;
		   } else {
		   }
			   

		  //Get the json config of the photo from a shared drive first
		  rearrangePaths(globalConfig);
		  
		  if(globalConfig.backupTo && globalConfig.backupTo[0]) {
					var readConfigFile = normalizeInclWinNetworks(nonRelativeMedImagePath + "/" + opts.photo.replace(".jpg", ".json")); 
					//Get the latest version cached locally   //TODO: better slashes here
											
					var sharedMasterConfigFile = globalConfig.backupTo[0] + "/master.json"; 
					try {
					  if (fs.existsSync(sharedMasterConfigFile)) {
						//master file exists
						//And copy shared master down to local master
						try {
						  fsExtra.copySync(sharedMasterConfigFile, masterConfigFile);
						  console.log('Copied shared master ' + sharedMasterConfigFile + ' to local master ' + masterConfigFile + ', success!');
						} catch (err) {
						  console.error(err);
						}
					  } else {
						//doesn't exist, so local master will be backed up, also
						try {
						  fsExtra.copySync(masterConfigFile, sharedMasterConfigFile);
						  console.log('Shared local master config, success!');
						} catch (err) {
						  console.error(err);
						}
					  }
					} catch(err) {
					  console.error(err);
					}
					
			  } else {
					var readConfigFile = normalizeInclWinNetworks(__dirname + "/" + mainMedImagePath + "/" + opts.photo.replace(".jpg", ".json"));
			  }
		  
		  
		  
		  readConfig(masterConfigFile, function(masterConf, err) {

			   if(err) {
				 console.log("Error reading master config file:" + err);
				 //Set up some blanks
				 masterConf = blankConf;
			   } else {
			   }
		  
		  
			
		
			  //Read the actual config file, be it a photo or a master config
			  readConfig(readConfigFile, function(conf, err) {

				   if(err) {
				 
					 //We should have access to the json file, since we've opened it up, but if there are any circumstances where this isn't the case, we can copy it back in here, in future.
					 console.log("Error reading config file:" + err);
					 //Set up some blanks
					 conf = blankConf;
					 var webViewPhoto = opts.photo.replace(replaceText, withWebViewText);
				 
				   } else {
						//Show a smaller photo file
						var webViewPhoto = opts.photo.replace(conf.output.scaledPhoto.nameConvention.replaceText, 				conf.output.scaledPhoto.nameConvention.withWebViewText);
				   }
			   
				   var coloursHTML = prepColourPairs(conf, "photo");	
				
				   //Now read in the master config, to get a different set of master colours
				   coloursHTML += "<br/><a title='Toggle global colour view' href='javascript:' class='btn btn-social btn-info' id='master-button'><i class='fa fa-globe'></i> Colours <i id='toggle-global' class='fa fa-chevron-down'></i></a><br/>";	
			   
			   

			   
					  //Append the master colours
					  coloursHTML += "<div id='master-colours' style='display: none'>" + prepColourPairs(masterConf, "global") + "</div>";	
			   
			   
				
			   
					   //Now prep the selection HTML, based on what was entered before.
					   var outputDarkToLight = 'selected="selected"';	//Default to dark to light
			   
					   //Toggle the range each time, if an upper/lower selected
					   if(opts.lowRange == "true") {
							var outputLowRange = '';
							var outputDarkToLight = '';
							var outputUpperRange = 'selected="selected"';
					   } 
				   
					   if(opts.lowRange == "false") {
							//So upper range just set, switch to lower
							var outputLowRange = 'selected="selected"';
							var outputUpperRange = '';
							var outputDarkToLight = '';
					   }
					   var selectionHTML = '<div class="col-lg-3"><select class="form-control" name="lowRange" id="lowRange-select"><option value="darkToLight" ' + outputDarkToLight + ' >Auto Range</option><option value="true" ' + outputLowRange + ' >Lower end of Range</option><option value="false" ' + outputUpperRange + '>Upper end of Range</option></select></div>';
			   
			   
					   var typeWound = '';
					   var typeSticker = '';
					   if(opts.type == "wound") {
							//Keep the type the same
							typeWound = 'selected="selected"';
					   }
					   if(opts.type == "sticker") {
							//Keep the type the same
							typeSticker = 'selected="selected"';
					   }
				   
					   selectionHTML += '<option type="hidden" name="type" value="sticker">';
			   
					var sessionId = "";
					if(opts.sessionId) {
						sessionId = opts.sessionId;
					}					
					
			   
			   
			   
					   console.log("returnParams:?CUSTOMIMAGE=" + opts.photo + "&CUSTOMWEBIMAGE=" + webViewPhoto + "&CUSTOMCOLOURS=" + encodeURIComponent(coloursHTML) + "&CUSTOMSELECTION=" + encodeURIComponent(selectionHTML) + "&SESSIONID=" + sessionId);
				 });		//End of read master file
			   
			});		//End of readConfig master
		});  //End of readConfig global
		
		
		
		


		

} else {
	

	console.log("Usage: node show-adjust-colours.js file/path/photo.jpg");


}
