
var fs = require('fs');
var fsExtra = require('fs-extra');
var upath = require('upath');
var queryString = require('querystring');
var path = require('path');
var area = require('area-polygon');
var resolve = require('path').resolve;

//var cvRefreshIsReady = false;


var session = require('../basic-authentication/session.js');


var verbose = false;		
var globalId = "";


// fine-tune.js version: 
var masterConfigFile = __dirname + '/config/master.json';
var mainMedImagePath = __dirname + "/../../photos";   //If run from two dirs in: "../../photos";
var globalConfigFile = __dirname + '/../../config.json';



//Include shared funcs
var normalizeInclWinNetworks = require(__dirname + '/common/libfuncs.js').normalizeInclWinNetworks;
var readConfig = require(__dirname + '/common/libfuncs.js').readConfig;
var writeConfig = require(__dirname + '/common/libfuncs.js').writeConfig;


//Include local library functions
var refresh = require(normalizeInclWinNetworks(__dirname + '/common/refresh-thumbnail.js')); 


//TODO: convert into an embedded version
async function onRuntimeInitialized() {
	  // load local image file with jimp. It supports jpg, png, bmp, tiff and gif:
  
	global.cvIsReady = true;
	console.log("CV runtime is ready!");

}


//Note: must be capital 'M' module
Module = {
  onRuntimeInitialized
}		//End of module


//Note: must be lower case 'm' module here.
module.exports = {
	medImage : function(argv, callback) {

		var callMedImageAgain = module.exports.medImage;
	
		if(!global.cvIsReady) {
			setTimeout(function() {
				var resp = "CV image processing runtime in refresh-thumbnail.js is not yet ready. We are trying again in 3 seconds.";
				
				
				//Always return { err, stdout, stderr }. Include an error in the first param if necessary.
				console.log(resp);
			
				callMedImageAgain(argv, callback);
				return;
			}, 3000);
			return;
		}
        

		if(argv[0]) {
			var param = decodeURIComponent(argv[0]);

			var opts = queryString.parse(param);
			
			var sessionId = "";
			if(opts.sessionId) {
				sessionId = opts.sessionId;
			}	

			if(opts.photo) {
				var photoConfigFile = mainMedImagePath + opts.photo.replace(".jpg", ".json");
				var readConfigFile = photoConfigFile;
			} else {
				 var resp = {
			   	 	"completed": false,
			   	 	"error": "Photo parameter missing"	   	 
			   	 } 
				 console.log("You need to pass a photo file.");
				 var output = "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));
				

				var ret = {};
				ret.err = "";
				ret.stdout = output;
				ret.stderr = "";
				
				//Always return { err, stdout, stderr }. Include an error in the first param if necessary.
				callback("Photo parameter missing", ret);	
				return;
			}

			var writeConfigFile = readConfigFile;		//Defaults to the same file to write

			readConfig(readConfigFile, function(newConf, err) {

			   if(err) {
			   	 
			   	 var resp = {
			   	 	"completed": false,
			   	 	"error": "Error reading config file:" + err	   	 
			   	 } 
				 var output = "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));
				

				 var ret = {};
				 ret.err = "";
				 ret.stdout = output;
				 ret.stderr = "";
				
				 //Always return { err, stdout, stderr }. Include an error in the first param if necessary.
				 callback(err, ret);	
				 return;
				 
			   } else {
			   		//We have read the config file
					
					//Change the config now
					
					var conf = newConf;		//Get local scope version

					var photoFile = mainMedImagePath + opts.photo;
					var webPhotoFile = photoFile.replace(conf.output.scaledPhoto.nameConvention.replaceText, 
												conf.output.scaledPhoto.nameConvention.withWebViewText);
					refresh.refreshThumbnail(global.cv, photoFile, webPhotoFile, conf, function(err, thumbnailFile) {
					
						var backupFiles = "";   //No backups needed anymore as using cache: "backupFiles:" + resolve(thumbnailFile) + "\n";
						
						var resp = {
									"completed": true,
									"error": null,
									"action": "Refreshed thumbnail photo"	   	 
								 } 
						
						var output = backupFiles + "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));
				

						 var ret = {};
						 ret.err = "";
						 ret.stdout = output;
						 ret.stderr = "";
						
						 //Always return { err, stdout, stderr }. Include an error in the first param if necessary.
						 callback(null, ret);	
						 return;
					
					}); 
				}
			});
		} else {
			console.log("Usage: e.g. fine-tune.js ?type=Wound&scope=global&id=3  but urlencoded");
		}
	}
}
  
	
// Load 'opencv.js' assigning the value to the global variable 'cv'
if(typeof global.cv === 'undefined'){
	global.cv = require('./opencv.js');	
}
