/* 

	MedImage Wound Add-on Installation Script


	Input on the command-line (urlencoded get query params):
	
	prepend: [true|false]  - defaults to false, so it inserts at the end of the event list. true would insert at the beginning
						of the event list. This affects the order of things in the case of the 'photoWritten' event, which
						can be chained together with other image processing tasks.
	firstRun: [true|false]  - from a full install, this should be set to 'true' to enable adding menu elements etc.
								However, we don't want to add those menu elements twice, so the 2nd time we can leave this off.

*/ 

var async = require("async");
var queryString = require('querystring');
var fs = require('fs');
var fsExtra = require('fs-extra');
const cheerio = require('cheerio');
var exec = require('child_process').exec;
var https = require('https');

var verbose = false;

var thisAddOnConfigFile = __dirname + '/config/master.json';
var thisAddOnORIGINALConfigFile = __dirname + '/config/masterORIGINAL.json';
var medImageAddonConfig = __dirname + "/../config.json";
var mainServerConfig = __dirname + "/../../config.json";

var pm2Parent = '';		//Include a string if this is run on linux that represents the MedImage server to restart


//Utility functions
function removeLastInstance(badtext, str) {
    var charpos = str.lastIndexOf(badtext);
    if (charpos<0) return str;
    ptone = str.substring(0,charpos);
    pttwo = str.substring(charpos+(badtext.length));
    return (ptone+pttwo);
}	

function strFunctionInserter(func) {
	var strver = func.toString();
	strver = strver.replace("function () { \/\/Remove-this-line","");		//Get rid of first function
	strver = strver.replace("function() { \/\/Remove-this-line","");		//Get rid of first function
	strver = removeLastInstance("}", strver);
	return JSON.stringify(strver);
}	


//Add-on content
var pagesToInsert = [
		{
			"from": __dirname + "/pages/photo-analysis.html",
			"to": __dirname + "/../../public/pages/photo-analysis.html",
			"replace": true
		},
		{
			"from": __dirname + "/pages/mob-photo-analysis.html",
			"to": __dirname + "/../../public/pages/mob-photo-analysis.html",
			"replace": true
		},
		{
			"from": __dirname + "/pages/photo-list.html",
			"to": __dirname + "/../../public/pages/photo-list.html",
			"replace": true
		},
		{
			"from": __dirname + "/pages/photo-search.html",
			"to": __dirname + "/../../public/pages/photo-search.html",
			"replace": true
		},
		{
			"from": __dirname + "/pages/photo-zoomed.html",
			"to": __dirname + "/../../public/pages/photo-zoomed.html",
			"replace": true
		},
		{
			"from": __dirname + "/pages/mob-photo-list.html",
			"to": __dirname + "/../../public/pages/mob-photo-list.html",
			"replace": true
		},
		{
			"from": __dirname + "/pages/wound-settings.html",
			"to": __dirname + "/../../public/pages/wound-settings.html",
			"replace": true
		},
		{
			"from": __dirname + "/config/sessionsORIGINAL.json",
			"to": __dirname + "/config/sessions.json",
			"replace": true
		},
		{
			"from": __dirname + "/images/please-login.png",
			"to": __dirname + "/../../public/images/please-login.png",
			"replace": true
		},
		{
			"from": __dirname + "/images/speech-bubble-start-1.png",
			"to": __dirname + "/../../public/images/speech-bubble-start-1.png",
			"replace": true
		},
		{
			"from": __dirname + "/css/zoom.css",
			"to": __dirname + "/../../public/css/zoom.css",
			"replace": true
		},
		{
			"from": __dirname + "/css/bootstrapcom.min.css",
			"to": __dirname + "/../../public/css/bootstrapcom.min.css",
			"replace": true
		},
		{
			"from": __dirname + "/css/comments-0.9.1.css",
			"to": __dirname + "/../../public/css/comments-0.9.1.css",
			"replace": true
		},
		{
			"from": __dirname + "/css/comments-1.0.3.css",
			"to": __dirname + "/../../public/css/comments-1.0.3.css",
			"replace": true
		},
		{
			"from": __dirname + "/css/comments-1.0.4.css",
			"to": __dirname + "/../../public/css/comments-1.0.4.css",
			"replace": true
		},
		{
			"from": __dirname + "/css/leaflet.css",
			"to": __dirname + "/../../public/css/leaflet.css",
			"replace": true
		},
		{
			"from": __dirname + "/css/leaflet-1.2.0.css",
			"to": __dirname + "/../../public/css/leaflet-1.2.0.css",
			"replace": true
		},
		{
			"from": __dirname + "/css/bootstrap.min-3.3.7.css",
			"to": __dirname + "/../../public/css/bootstrap.min-3.3.7.css",
			"replace": true
		},
		{
			"from": __dirname + "/fonts/glyphicons-halflings-regular.woff2",
			"to": __dirname + "/../../public/fonts/glyphicons-halflings-regular.woff2",
			"replace": true
		},
		{
			"from": __dirname + "/js/leaflet-src.js",
			"to": __dirname + "/../../public/js/leaflet-src.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/html5shiv.js",
			"to": __dirname + "/../../public/js/html5shiv.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/respond.min.js",
			"to": __dirname + "/../../public/js/respond.min.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/freehandshapes.js",
			"to": __dirname + "/../../public/js/freehandshapes.js",
			"replace": true
		},
		{
			"from": __dirname + "/css/freehandshapes.css",
			"to": __dirname + "/../../public/css/freehandshapes.css",
			"replace": true
		},
		{
			"from": __dirname + "/js/turf-web-worker.min.js",
			"to": __dirname + "/../../public/js/turf-web-worker.min.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/chat-0.9.2.js",
			"to": __dirname + "/../../public/js/chat-0.9.2.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/chat-1.0.3.js",
			"to": __dirname + "/../../public/js/chat-1.0.3.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/chat-1.0.4.js",
			"to": __dirname + "/../../public/js/chat-1.0.4.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/chat-1.0.7.js",
			"to": __dirname + "/../../public/js/chat-1.0.7.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/chat-1.0.8.js",
			"to": __dirname + "/../../public/js/chat-1.0.8.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/chat-1.0.9.js",
			"to": __dirname + "/../../public/js/chat-1.0.9.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/chat-1.1.1.js",
			"to": __dirname + "/../../public/js/chat-1.1.1.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/ramda.js",
			"to": __dirname + "/../../public/js/ramda.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/leaflet-freedraw.web.js",
			"to": __dirname + "/../../public/js/leaflet-freedraw.web.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/turf.min.js",
			"to": __dirname + "/../../public/js/turf.min.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/jquery.min-3.1.1.js",
			"to": __dirname + "/../../public/js/jquery.min-3.1.1.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/leaflet-1.2.0.js",
			"to": __dirname + "/../../public/js/leaflet-1.2.0.js",
			"replace": true
		},
		{
			"from": __dirname + "/js/leaflet-freehandshapes.js",
			"to": __dirname + "/../../public/js/leaflet-freehandshapes.js",
			"replace": true
		},
		{
			"from": __dirname + "/pages/export.csv",
			"to": __dirname + "/../../public/pages/export.csv",
			"replace": true
		}
	];
	
	
	

//This function's contents will be placed into the HTML as-is
var jQueryDyn = function() { //Remove-this-line
	jQuery(document).ready(function(){
		jQuery('#wound-tab').click(function() {
			//Get the current settings HTML snippet via an ajax request

			uri = "/addon/wound-view-settings/";
			jQuery.ajax({
				url: uri,
				success: function(data) {
					jQuery('#wound').html(data);
				}
			 }); 

		});

	});
}	
	
var htmlToInsert = [
		{
			"file": __dirname + "/../../public/components/header.html",
			"selector": "#side-menu",
			"newId": "see-photos",
			"append": "<li id='see-photos'><a href='/pages/photo-search.html'><i class='fa fa-picture-o fa-fw'></i> See Photos</a></li>"
		},
		{
			"file": __dirname + "/../../public/components/header.html",
			"selector": "#side-menu",
			"newId": "settings",
			"append": "<li id='settings'><a href='/pages/addon-settings.html'><i class='fa fa-gear fa-fw'></i> Settings</a></li>"
		},
		{
			"file": __dirname + "/../../public/pages/addon-settings.html",
			"selector": "#setting-tabs",
			"newId": "wound-tab",
			"append": "<li><a id='wound-tab' href='#wound' data-toggle='tab'>Wound Add-on</a></li>"
		},
		{
			"file": __dirname + "/../../public/pages/addon-settings.html",
			"selector": "#tab-content",
			"newId": "wound",
			"append": "<div class='tab-pane fade' id='wound'></div><script id='woundScript'>" + JSON.parse(strFunctionInserter(jQueryDyn)) + "</script>"
		}
		
		
	];
	/*
		Or a remove example
		{
			"file": __dirname + "/../../public/components/header.html",
			"selector": "#settings",
			"remove": true
		},
	
	*/

var thisAppEventPhotoWritten = [
									{
										"addon": "Wound Analysis",
										"runProcess": "node parentdir/addons/wound/wound-size.js param1",
										"priority": "high",
										"active": true
									}	
                       		 	];
var thisAppEventURLRequest = [
									{
										"addon": "Wound Analysis",
										"scriptURLName": "grab-colour",
										"runProcess": "node parentdir/addons/wound/hue-due.js param1",
										"waitForRequestFinish":  "photo-zoomed.html",
										"priority": "high",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "regenerate-analysis",
										"runProcess": "node parentdir/addons/wound/wound-size.js param1",
										"waitForRequestFinish": "snippet.html",
										"priority": "high",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "show-analysis",
										"runProcess": "node parentdir/addons/wound/show-wound-size.js param1 param2",
										"waitForRequestFinish": "photo-analysis.html",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "show-adjust-colour",
										"runProcess": "node parentdir/addons/wound/show-adjust-colours.js param1",
										"waitForRequestFinish": "photo-zoomed.html",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "show-photo",
										"runProcess": "node parentdir/addons/wound/show-photo.js param1",
										"priority": "high",
										"waitForRequestFinish": "",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "get-photos",
										"runProcess": "node parentdir/addons/wound/get-photos.js param1",
										"priority": "high",
										"waitForRequestFinish": "snippet.html",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "fine-tune",
										"runProcess": "node parentdir/addons/wound/fine-tune.js param1",
										"waitForRequestFinish": "snippet.html",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "wound-set",
										"runProcess": "node parentdir/addons/wound/install.js param1",
										"waitForRequestFinish":  "addon-settings.html",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "wound-view-settings",
										"runProcess": "node parentdir/addons/wound/view-settings.js",
										"waitForRequestFinish":  "wound-settings.html",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"runProcess": "node parentdir/addons/wound/view-tab-settings.js param1",
										"scriptURLName": "view-tab-settings",
										"waitForRequestFinish":  "addon-settings.html",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "export",
										"runProcess": "node parentdir/addons/wound/export.js param1",
										"priority": "high",
										"waitForRequestFinish": "export.csv",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "fine-tune-large",
										"priority": "high",
										"runProcess": "node parentdir/addons/wound/fine-tune-large.js param1",
										"waitForRequestFinish": "snippet.html",
										"active": true
									},
									{
										"addon": "Wound Analysis",
										"scriptURLName": "refresh-thumbnail",
										"priority": "high",
										"runProcess": "node parentdir/addons/wound/refresh-thumbnail.js param1",
										"waitForRequestFinish": "snippet.html",
										"active": true
									}
									
									
                       		 ];
                       		 
var outgoingOptions = {};


function readConfig(confFile, cb) {
	//Reads and updates config with a newdir in the output photos - this will overwrite all other entries there
	//Returns cb(err) where err = null, or a string with the error


	//Write to a json file with the current drive.  This can be removed later manually by user, or added to
	fs.readFile(confFile, function read(err, data) {
		if (err) {
				cb(null, "Sorry, cannot read config file! " + confFile + ". Error: " + err);
		} else {
			try {
				var content = JSON.parse(data);
				cb(content, null);
			} catch (e) {
				console.log("Error reading json file " + confFile + ". Error:" + JSON.stringify(e));
				cb({});		//Use a blank object file instead
			}

			
		};
	});

}


function writeConfig(confFile, content, cb) {
	//Write the file nicely formatted again
	fs.writeFile(confFile, JSON.stringify(content, null, 6), function(err) {
		if(err) {
			console.log("Error writing config file: " + err);
			cb(err);
			
		} else {
		
			console.log("The config file was saved! " + confFile);

		
			cb(null);
		}
	});
}


function inArrayAlready(objCheck, inThisArray) 
{
	//Checks the objCheck is not already in the array - saves us from doubling up. Note - if the status
	//is true vs false, it will still include both options.
	//Returns true if in the array, and false if not.
	var strOfObj = JSON.stringify(objCheck);
	
	for(var cnt = 0; cnt< inThisArray.length; cnt++) {
		if(strOfObj === JSON.stringify(inThisArray[cnt])) {
			return true;
		}
	}
	//Fall through - is not in array
	return false;

}


function addToMedImageServerConfig(configContents, insertObjArray, eventName, prepend)
{
	//In an already loaded config, insert the objects specified in the 'insertObjArray', into the event array called 'eventName'
	// (e.g. 'photoWritten' or 'urlRequest')
	//It will either insert it at the end (prepend = false) or at the beginning (prepend = true).
	//
	//Will return the modified config file, which should then be written to disk again.
	if(!prepend) {
		var prepend = false;		//default to push at the end
	}

	if(!configContents.events) {
		configContents.events = [];
	}
	
	if(!configContents.events[eventName]) {
		configContents.events[eventName] = [];	
	}
	
	if(prepend == true) {
		//Go through the array of objects backwards
		for(var cnt = (insertObjArray.length - 1); cnt >= 0; cnt--) {
			if(! inArrayAlready(insertObjArray[cnt], configContents.events[eventName])) {
				configContents.events[eventName].unshift(insertObjArray[cnt]);	//insert at the start of the chain, but backwards so
			}														//it will keep the same order
		}
	} else {
		//Go through the array of objects forwards
		for(var cnt = 0; cnt< insertObjArray.length; cnt++) {
			if(! inArrayAlready(insertObjArray[cnt], configContents.events[eventName])) {
				configContents.events[eventName].push(insertObjArray[cnt]);	//insert at the end of the chain
			}
		}
	}
	
	return configContents;
}


function restartParentServer(cb)
{
	//Restart the parent MedImage service
	var platform = process.platform;
	var isWin = /^win/.test(platform);
	if(isWin) {
		var run = 'net stop MedImage';
		if(verbose == true) console.log("Running:" + run);
		exec(run, function(error, stdout, stderr){
			if(error) {
				console.log("Error stopping MedImage:" + error);
				cb();
			
			} else {
				console.log(stdout);
			
				var run = 'net start MedImage';
				exec(run, function(error, stdout, stderr){
					if(error) {
						console.log("Error starting MedImage:" + error);
						cb();
					} else {
						console.log(stdout);
						cb();
					}
				});
			}
		});
	} else {
	   //Probably linux
	   if((pm2Parent) && (pm2Parent != '')) {
		   var run = 'pm2 restart ' + pm2Parent;
			if(verbose == true) console.log("Running:" + run);
			exec(run, function(error, stdout, stderr){
				console.log(stdout);
				cb();
			});
		}
	}

}


function changeLocalConfig(configContents, opts, cb)
{

	if(!configContents.output) {
		configContents.output = {};
	}

	if(opts.area) {
		if(configContents.input && configContents.input.sticker) {
			configContents.input.sticker.physicalAreaSquareCm = opts.area;
		}
	}
	
	if(opts.autoWoundDetection) {
		//If this option exists (i.e. from a checkbox being on, then use it
		if(configContents.input && configContents.input.wound) {
			configContents.input.wound.autoWoundDetection = true;
		}
	} else {
		if(configContents.input && configContents.input.wound) {
			configContents.input.wound.autoWoundDetection = false;
		}	
	}
	
	
		
	if(opts.autoCapitaliseID && opts.autoCapitaliseID === "yes") {
		//If this option exists (i.e. from a checkbox being on, then use it.
		configContents.output.autoCapitaliseID = false;
		
	} else {
		
		if(!configContents.output.hasOwnProperty("autoCapitaliseID")) {
			configContents.output.autoCapitaliseID = false;		//Default to false
		} else {
			//Otherwise set it to true
			configContents.output.autoCapitaliseID = true;
		}
	
	}
	
	
	if(opts.ajServer) {
		//If this option exists we should use messaging.
		if(configContents.output) {
			
			if(opts.ajServer != "Private") {
				configContents.output.ajServer = encodeURIComponent(opts.ajServer);
			}
				
		} else {
			//In case this hasn't been set yet.
			configContents.output = {};
			configContents.output.ajServer = encodeURIComponent(opts.ajServer);
		}
		
	} else {
		if(configContents.output) {
			//Set a default to a blank
			configContents.output.ajServer = "";
		}	
	}
	
	if(opts.ajRoot) {
		//If this option exists (i.e. from a checkbox being on, then use it.
		if(configContents.output) {
			
			if(opts.ajRoot != "Private") {
				configContents.output.ajRoot = encodeURIComponent(opts.ajRoot);
			}
				
		} else {
			//In case this hasn't been set yet.
			configContents.output = {};
			configContents.output.ajRoot = encodeURIComponent(opts.ajRoot);
		}
		
	} else {
		if(configContents.output) {
			configContents.output.ajRoot = encodeURIComponent("aj45iufhWoundDefaultChangemeNow-");
		}	
	}

	if(opts.ajCSS) {
		//If this option exists (i.e. from a checkbox being on, then use it.
		if(configContents.output) {
			
			if(opts.ajCSS != "Private") {
				configContents.output.ajCSS = encodeURIComponent(opts.ajCSS);
			}
				
		} else {
			//In case this hasn't been set yet.
			configContents.output = {};
			configContents.output.ajCSS = encodeURIComponent(opts.ajCSS);
		}
		
	} else {
		if(configContents.output) {
			configContents.output.ajCSS = encodeURIComponent("https://frontcdn.atomjump.com/atomjump-frontend/comments-1.0.4.css");
		}	
	}
	
	
	if(opts.ajJS) {
		//If this option exists (i.e. from a checkbox being on, then use it.
		if(configContents.output) {
			
			if(opts.ajJS != "Private") {
				configContents.output.ajJS = encodeURIComponent(opts.ajJS);
			}
				
		} else {
			//In case this hasn't been set yet.
			configContents.output = {};
			configContents.output.ajJS = encodeURIComponent(opts.ajJS);
		}
		
	} else {
		if(configContents.output) {
			configContents.output.ajJS = encodeURIComponent("../js/chat-1.1.1.js");
		}	
	}
	
	
	
	if(opts.ajBaseCSS) {
		//If this option exists (i.e. from a checkbox being on, then use it.
		if(configContents.output) {
			
			if(opts.ajBaseCSS != "Private") {
				configContents.output.ajBaseCSS = encodeURIComponent(opts.ajBaseCSS);
			}
				
		} else {
			//In case this hasn't been set yet.
			configContents.output = {};
			configContents.output.ajBaseCSS = encodeURIComponent(opts.ajBaseCSS);
		}
		
	} else {
		if(configContents.output) {
			configContents.output.ajBaseCSS = encodeURIComponent("https://frontcdn.atomjump.com/atomjump-frontend/bootstrap.min.css");
		}	
	}	
	
	
	if(opts.ajDomain) {
		//If this option exists (i.e. from a checkbox being on, then use it.
		if(configContents.output) {
			
			if(opts.ajDomain != "Private") {
				configContents.output.ajDomain = encodeURIComponent(opts.ajDomain);
			}
				
		} else {
			//In case this hasn't been set yet.
			configContents.output = {};
			configContents.output.ajDomain = encodeURIComponent(opts.ajDomain);
		}
		
	} else {
		if(configContents.output) {
			configContents.output.ajDomain = encodeURIComponent("");
		}	
	}	
	
	
	if(opts.ajMachineUser) {
		//If this option exists (i.e. from a checkbox being on, then use it.
		if(configContents.output) {
			
			if(opts.ajBaseCSS != "Private") {
				configContents.output.ajMachineUser = encodeURIComponent(opts.ajMachineUser);
			}
				
		} else {
			//In case this hasn't been set yet.
			configContents.output = {};
			configContents.output.ajMachineUser = encodeURIComponent(opts.ajMachineUser);
		}
		
	} else {
		if(configContents.output) {
			configContents.output.ajMachineUser = encodeURIComponent("192.104.113.117:8");
		}	
	}
	
	
	if(opts.woundTracing) {
		//If this option exists (i.e. from a checkbox being on, then use it.
		var setThis = false;
		
		if(configContents.output) {
			
			if(opts.woundTracing != "Private") {
				var oldWoundTracing = configContents.output.woundTracing;
				configContents.output.woundTracing = encodeURIComponent(opts.woundTracing);
				setThis = true;
			}
				
		} else {
			//In case this hasn't been set yet.
			configContents.output = {};
			setThis = true;
			
			
		}
		
		
		
		if(setThis == true) {
			configContents.output.woundTracing = encodeURIComponent(opts.woundTracing);
			
			//Check a new URL
			if(oldWoundTracing != configContents.output.woundTracing) {
				/* Now send the URL e.g. https://medimage-pair.atomjump.com/med-settings.php?type=set&guid=0uuWCmCfeckol8ulhe&settings={"url-encoded":"json"}
				where the JSON is { "woundTracingURL" : "https://yourserver.com" }
				URLencoded overall. 
				*/
				var sendJSON = {
					"woundTracingURL" : opts.woundTracing
				};
			
				sendJSON = encodeURIComponent(JSON.stringify(sendJSON));
				
				
				readConfig(mainServerConfig, function(mainServerConfig,err) {
					if(!err) {
						if(mainServerConfig.globalId) {
					
						
							var guid = mainServerConfig.globalId;
						
						
						
							//Do a GET get old values request to the overall URL to 
							var fullURL = "https://medimage-pair.atomjump.com/med-settings.php?type=get&guid=" + guid;
							console.log("Settings set URL: " + fullURL);
							
							https.get(fullURL, (resp) => {
							  var data = '';

							  // A chunk of data has been recieved.
							  resp.on('data', (chunk) => {
								data += chunk;
							  });

							  // The whole response has been received. Print out the result.
							  resp.on('end', () => {
									//OK, with the data, use this as the basis for the sendJSON.
									try {
										//Sort out the data we're going to send
										sendJSON = JSON.parse(data);
									} catch(err) {	//Problem with the partse
										//return with the error
										cb(err, configContents);
										return;
									}
									
									sendJSON.woundTracingURL = opts.woundTracing;
									sendJSON = encodeURIComponent(JSON.stringify(sendJSON));
									
										
									//Do a GET setting request to the overall URL
									var fullURL = "https://medimage-pair.atomjump.com/med-settings.php?type=set&guid=" + guid + "&settings=" + sendJSON;
									console.log("Settings set URL: " + fullURL);
						
									https.get(fullURL, (resp) => {
									  var data = '';

									  // A chunk of data has been recieved.
									  resp.on('data', (chunk) => {
										data += chunk;
									  });

									  // The whole response has been received. Print out the result.
									  resp.on('end', () => {
										cb(null, configContents); 
									  });

									}).on("error", (err) => {
									  cb("Settings error: " + err.message, configContents);
									});
									
								
							  });

							}).on("error", (err) => {
							  cb("Settings error: " + err.message, configContents);
							});
						
						
						
							
							
							
							
						} else {
							//Don't yet have a global ID, so we cannot save this.
							configContents.output.woundTracing = "[Please connect to a remote MedImage Server, first (e.g. AJ or your own)]";
							cb(null, configContents);
						}
					
						
					
					} else {
						
						cb("Warning: could not read the MedImage Server config file.",  configContents);
					}
			
			
				});
			} else {	//End of check a new url
				cb(null, configContents);
			
			}
		} else { //End of set this
			cb(null, configContents);
		}
		
		
		
	} else {
		//No wound tracing
		if(configContents.output) {
			//Default to blank
			configContents.output.woundTracing = "";
		}	
		cb(null, configContents);
	}
	
}



function getPlatform() {
	var platform = process.platform;
	if(verbose == true) console.log(process.platform);
	var isWin = /^win/.test(platform);
	if(verbose == true) console.log("IsWin=" + isWin);
	if(isWin) {
		if(process.arch == 'x64') {
			return "win64";
		} else {
			return "win32";
		}
	} else {
		if(platform == "darwin") {
			return "mac";
		} else {
			return "unix";
		}
	
	}
}





//Read in the command-line params
if(process.argv[2]) {

	//Incoming get requests are in normal "var=value&var2=value" format urlencoded
	var opts = queryString.parse(decodeURIComponent(process.argv[2]));
	
	if(process.argv[2] == 'first') {
		//Shortcut for command line users rather than having to enter firstRun%3Dtrue
		opts.firstRun = "true";
		opts.autoCapitaliseID = true;
	}
	
	//Read in the local app's config file

	async.waterfall([
		function(callback) {
			//Determine whether we should be using a shared drive wound master config
			//thisAddOnConfigFile contains the local version of the Wound add-on
			var actualConfigFiles = {
				"masterConfigFile" : thisAddOnConfigFile,
				"sharedMasterConfigFile" : "",
				"actualConfigFile" : thisAddOnConfigFile
			}
			
			
			readConfig(mainServerConfig, function(globConf, err) {
				if(!err) {
					//With this global config, determine whether we should use a remote version
					if(globConf.backupTo && globConf.backupTo[0]) {
						//By default use the destination version, since that is shared. It sits in the home folder of the shared drive folder						
				
						actualConfigFiles.sharedMasterConfigFile = globConf.backupTo[0] + "/master.json"; 
						actualConfigFiles.actualConfigFile = actualConfigFiles.sharedMasterConfigFile;
						try {
						  if (fs.existsSync(actualConfigFiles.sharedMasterConfigFile)) {
							//master file exists
							//And copy shared master down to local master
							try {
							  fsExtra.copySync(actualConfigFiles.sharedMasterConfigFile, actualConfigFiles.masterConfigFile);
							  console.log('Copied shared master ' + actualConfigFiles.sharedMasterConfigFile + ' to local master ' + actualConfigFiles.masterConfigFile + ', success!');
							} catch (err) {
							  console.error(err);
							}
						  } else {
							//doesn't exist, so local master will be backed up, also
							try {
							  fsExtra.copySync(actualConfigFiles.masterConfigFile, actualConfigFiles.sharedMasterConfigFile);
							  console.log('Shared local master config, success!');
							} catch (err) {
							  console.error(err);
							}
						  }
						} catch(err) {
						  console.error(err);
						}
						
				
						callback(null, actualConfigFiles);
				
					} else {
						//Otherwise use the local version
						callback(null, actualConfigFiles);
					}
				} else {
					callback(err, actualConfigFiles);
				
				}
			});
			
			
		
		},	
		function(actualConfigFiles, callback) {
			//Read the local add-on's config
			
			var actualConfigFile = actualConfigFiles.actualConfigFile;
			
			console.log("Trying to read : " + actualConfigFile);
			
			readConfig(actualConfigFile, function(childConfigContents, err) {
				if(!childConfigContents) {
					var childConfigContents = {};
				}
				
				if(err) {
					//OK check if the file even exists - if it doesn't continue on to create one
					fs.lstat( actualConfigFiles.actualConfigFile, function (staterr, inodeStatus) {
						  if (staterr) {

							// file does not exist-
							if (staterr.code === 'ENOENT' ) {
							  console.log("Error loading the add-on's own config file. Will try creating one:" + err); 
							  
							  
							  //Use the configORIGINAL version of the file
							  readConfig(thisAddOnORIGINALConfigFile, function(childConfigContents, err) {
							  
							  		if(!err) {
							  			//Add in the data
							  			childConfigContents = changeLocalConfig(childConfigContents, opts, function(err, childConfigContents) {
							  			
							  				actualConfigFiles.childConfigContents = childConfigContents;
							  				callback(err, actualConfigFiles);		//So continue
							  			
							  			});
							  			
							  		} else {
							  			//An error reading the original config file
							  			console.log("Error loading the add-on's original config file:" + err); 
										callback(staterr, null);
							  		}
							  });
							  
							} else {

								// miscellaneous error (e.g. permissions)
								console.log("Error loading the add-on's own config file:" + err); 
								callback(staterr, null);
							}
						  } else {
						  	//All good with the file, so we don't want to overwrite it. Stop here.
						  	console.log("Error loading the add-on's own config file:" + err); 
							callback(err, null);
						  
						  }
					});

						
					
				} else {
					
					
					
					
					//Modify the addon config for the master server
					//But only modify this master.json if it isn't the first install run. If it is the first run, and we are here
					//it means we have already been installed before, and we don't want to overwrite it. 
					if(opts.firstRun !== "true") {
						console.log("Modified master.json");
						childConfigContents = changeLocalConfig(childConfigContents, opts, function(err, childConfigContents) {
							actualConfigFiles.childConfigContents = childConfigContents;
							callback(err, actualConfigFiles);
						
						});
						
					} else {
						console.log("Kept old master.json");
						actualConfigFiles.childConfigContents = childConfigContents;
						callback(null, actualConfigFiles);
					}			
				}
				
			});
		},
		function(actualConfigFiles, callback) {
			
			//Write back the add-on's config file
			outgoingOptions = actualConfigFiles.childConfigContents;		//Get a global backup for when we exit this script
			
			
			
			
			writeConfig(actualConfigFiles.actualConfigFile, actualConfigFiles.childConfigContents, function(err) {
				if(err) {
					console.log("Error saving the add-on config file:" + err);
					callback(err); 
		
				} else {
					//Success writing the new wound master.json config
					
					//Now create a local backup if appropriate
					
					if(actualConfigFiles.sharedMasterConfigFile != "") {
						if(actualConfigFiles.sharedMasterConfigFile == actualConfigFiles.actualConfigFile) {
							//Want to do the backup of this file ourselves - because it isn't in the normal
							//folders. 
							//Copy global master down to local master
							try {
							  fsExtra.copySync(actualConfigFiles.sharedMasterConfigFile, actualConfigFiles.masterConfigFile);
							  console.log('Backing up global master ' + actualConfigFiles.sharedMasterConfigFile  + ' to local ' + actualConfigFiles.masterConfigFile + ' success!');
							} catch (err) {
							  console.error(err);
							}
							//No need for a backupFiles signal to the main parent MedImage
						 } else {
						
							//Save it up as the global master
							try {
							  fsExtra.copySync(actualConfigFiles.masterConfigFile, actualConfigFiles.sharedMasterConfigFile);
							  console.log('Backing up master ' + actualConfigFiles.masterConfigFile  + '  to global master ' + actualConfigFiles.sharedMasterConfigFile + ' success!');
							} catch (err) {
							  console.error(err);
							}
						
						 }
					}
					callback(null);
				}			
			});
		},
		function(callback) {
			//Read the medImage General AddonConfig
			readConfig(medImageAddonConfig, function(parentConfigContents, err) {
				if(err) {
				
					
				
					//OK check if the file even exists - if it doesn't continue on to create one
					fs.lstat( medImageAddonConfig, function (staterr, inodeStatus) {
						  if (staterr) {

							// file does not exist-
							if (staterr.code === 'ENOENT' ) {
							  console.log("Error loading the master add-on config file. Will try creating one:" + staterr); 
							  
							  var parentConfigContents = {
								"events": {
									"photoWritten": [
									],
									"urlRequest": [
									]
								}
							  };
							  
							  
							  //Add in the data
							  parentConfigContents = addToMedImageServerConfig(parentConfigContents, thisAppEventPhotoWritten, "photoWritten", prepend);
							  parentConfigContents = addToMedImageServerConfig(parentConfigContents, thisAppEventURLRequest, "urlRequest", prepend);
							  
							  callback(null, parentConfigContents);		//So continue
							  
							} else {

								// miscellaneous error (e.g. permissions)
								console.log("Error loading the master add-on config file:" + err); 
								callback(staterr, null);
							}
						  } else {
						  	//All good with the file, so we don't want to overwrite it. Stop here.
						  	console.log("Error loading the master add-on config file:" + err); 
							callback(err, null);
						  
						  }
					});
				
				
				} else {
					if((opts.prepend)&&(opts.prepend === "true")) {
						var prepend = true;
					} else {
						var prepend = false;
					}
		
					//Modify the addon config for the master server
					parentConfigContents = addToMedImageServerConfig(parentConfigContents, thisAppEventPhotoWritten, "photoWritten", prepend);
					parentConfigContents = addToMedImageServerConfig(parentConfigContents, thisAppEventURLRequest, "urlRequest", prepend);
							  
					callback(null, parentConfigContents);				
				}
				
			});
			
		},
		function(parentConfigContents, callback) {
			
			writeConfig(medImageAddonConfig, parentConfigContents, function(err) {
				if(err) {
					console.log("Error saving the add-on config file:" + err);
					callback(err); 
		
				} else {
					//Success
					callback(null);
				}			
			});
		},
		function(callback) {
			//Copy across any pages that need inserting
			if(opts.firstRun === "true") {
				//But only do this on the first run
			
				async.eachOf(pagesToInsert,
						// 2nd param is the function that each item is passed to
						function(pageIns, cnt, cb){
							fsExtra.copy(pageIns.from, pageIns.to, { "overwrite": pageIns.replace }, function(err) {
								if(err) {
									cb(err);
								} else {
									cb(null);
								}
							});
						},	//End of async eachOf single item
						function(err){
							// All tasks are done now
							if(err) {
							   console.log('ERR:' + err);
							   callback(err);
							 } else {
							   console.log('Completed all page insertion!');
							   callback(null);
							 }
						   }
					); //End of async eachOf all items
			} else {
				callback(null);
				
			}
		},
		function(callback) {
			//Copy across any pages that need inserting
			callback(null);
			
			/* OLD no longer needed
			//Switch 'keepMaster' to true. We cannot handle the files being moved off into a new location, and losing
			//the originals on the fly. We can backup to a new location and view off of it though.

			
			readConfig(mainServerConfig, function(configContents,err) {
				if(!err) {
					configContents.keepMaster = true;
					
					writeConfig(mainServerConfig, configContents, function(err) {
						if(err) {
							console.log("Warning: you need to manually set 'keepMaster' to 'true' in the master config file for MedImage Server. Could not write to the file.");
						}					
						callback(null);
					
					});			
					
					
				} else {
					console.log("Warning: you need to manually set 'keepMaster' to 'true' in the master config file for MedImage Server. Could not read the file.");
					callback(null);
				}
			
			
			});
			*/
		},		
		function(callback) {
			//And add any menus or any other html pages that need to be adjusted
			if(opts.firstRun === "true") {
				//We only want to do this on the first run from a full install
			
				
				async.eachOf(htmlToInsert,
					// 2nd param is the function that each item is passed to
					function(htmlIns, cnt, cb){
						
				
						var htmlSource = fs.readFileSync(htmlIns.file, "utf8");
				
						const $ = cheerio.load(htmlSource);
				
					
						if(htmlToInsert[cnt].append) {
							console.log("Check exists id: " + htmlIns.newId);
							var exists = $("#" + htmlIns.newId).length;
							if(!exists) {
								//Only insert if not already there
								console.log("Doesn't exist");
								$(htmlIns.selector).append(htmlIns.append);
							} else { 
								console.log("Already exists");
							}
						}
				
						if(htmlIns.remove) {
							$(htmlIns.selector).remove();
						}

						if(verbose == true) console.log("New HTML:" + $.html());
						fs.writeFileSync(htmlIns.file, $.html());
						cb(null);
					
					},	//End of async eachOf single item
					  function(err){
						// All tasks are done now
						if(err) {
						   console.log('ERR:' + err);
						   callback(err);
						 } else {
						   console.log('Completed all code insertion!');
						   
						   //Now we need to restart the MedImage Server service (particularly if we have changed the header
						   //which is stored in RAM)
						   var platform = getPlatform();
						   if((platform == "win32")||(platform == "win64")) {
							   //Now we need to restart the MedImage Server service (particularly if we have changed the header
							   //which is stored in RAM)
							   restartParentServer(function(){ 
										callback(null);
						   
							   });
							} else {
							   //Ensure we reload the important bits of the server, header page and config
							   // (but do not restart it - as it could be the server running this installer)
							   console.log("reloadConfig:true");
							   callback(null);
							
							}
						   
						   
						   
						 }
					   }
				); //End of async eachOf all items
											
				
				
				
				
			} else {	//Not the first run
				callback(null);
			}
		}
		
	], function (err, result) {
		// result now equals 'done'
		if(err) {
			console.log("The installation was not complete. Error: " + err);
			process.exit(1);
		} else {
			console.log("The installation was completed successfully!");
			if(outgoingOptions.conf && outgoingOptions.conf.input && outgoingOptions.conf.input.sticker && outgoingOptions.conf.input.sticker.physicalAreaSquareCm) {
				var area =  outgoingOptions.conf.input.sticker.physicalAreaSquareCm;
			} else {
				var area = 1.0;
			}
			console.log("returnParams:?AREA=" + area);
			process.exit(0);
		}
	});

			


} else { 
	console.log("Usage: node install.js area=5.43&prepend=false\n\nBut the parameter should be urlencoded.");
}
	


