/*

MedImage Wound Analysis Add-on - Display directory in a drop-down box
==============================

Developed by (C) AtomJump Ltd. 10 Aug 2017. This is a commercial add-on to MedImage, and is licensed
by AtomJump on a per-server basis.

This script is an external API call to find the directories and files available to browse.
- Inputs are a partially complete string e.g. "#peter blist", which will search for the folder 'peter', followed
  by the photo files .jpg in that folder that start with the letters 'blist'.

- It outputs an array of objects with label and value properties:
 [ { "label": "Option1", "value": "value1" },
   { "label": "Option2", "value": "value2" } ... ]
 ready for a jQuery autocomplete.  E.g.
 [ { "label": "#peter blister (10-June-2017 10:30am 56secs)", "value": "/peter/blister-10-June-2017-10-30-56.jpg" },
   { "label": "#peter blister (20-June-2017 10:40am 34secs)", "value": "/peter/blister-10-June-2017-10-40-34.jpg" }]
 

*/



var fs = require('fs');
var upath = require('upath');
var queryString = require('querystring');
var fsExtra = require('fs-extra');
var path = require('path');
var Glob = require("glob").Glob;

var verbose = false;			//Usually 'false' unless testing



var async = require('async');
var resolve = require('path').resolve;

var session = require('../basic-authentication/session.js');

var pathSearcher = '/';

//Create a platform unspecific globber called myGlob(absolutepath, cb(err, list));
var platform = process.platform;
var isWin = /^win/.test(platform);
if(isWin) {
	pathSearcher = '\\';
	
	var targetDrive = "C:\\";
	var winSharedDrive = false;

	//A windows style glob
		
	myGlob = function(searchAbs, options, cb) {
		//var searchRel = upath.relative(__dirname, searchAbs);
		var searchRel = upath.relative(process.cwd(), searchAbs);
		if(verbose == true) console.log("Relative path in unix terms:" + searchRel);
		
		
		/*
			On Windows in a shared drive environment, we'll need:
			//process.chdir('P://');
			//var searchRel = ".//WoundMapp//CHECK2//*";
		
			Note: the double slashes. And we need to change the drive letter. A raw network path doesn't
			seem to work with glob-fs.
			
		*/

		
		if((searchAbs[1]) && (searchAbs[1] == ':') && (searchAbs[0].toUpperCase() != 'C')) {
			winSharedDrive = true;
			var oldCwd = process.cwd();
			//Very Likely a Windows path. 
			//Change the drive folder.
			targetDrive = searchAbs.charAt(0).toUpperCase() + ":\\";			//Change the global var
			process.chdir(searchAbs.charAt(0).toUpperCase() + "://");
			searchRel = upath.relative(process.cwd(), searchAbs);
			if(verbose == true) console.log("Relative path in unix terms from new shared drive letter:" + searchRel); 
			
			//Double up the slashes.
			searchRel = searchRel.replace(/\//g, '\/\/');
			
			if(verbose == true) console.log("glob-fs search path:" + searchRel); 
		}
		
		
		var glob = require('glob-fs')({ recurse: false, gitignore: true, nocase:true });  //'nocase: true' only works when it is a folder. So, instead we will either 
														 //be fully upper cased first word or fully lower cased, and we'll try 
														 //searching for both options.		
		
		var masterList = [];

		glob.readdir(searchRel, { recurse: false, gitignore: true, nocase:true }, function(err, list) {
			//Do a second level to take into account subdirectories.
			masterList = masterList.concat(list);
			var thisMasterList = masterList;
			var searchSubfolders = true;
			
			if(options.term) {
				//We have the originally entered search term, which always starts with a #, e.g. #t, or #test
				//If this is a single character search, don't search subfolders
				if(options.term.length <= 2) {
					searchSubfolders = false;
					cb(null, thisMasterList);
				}
			}
			
			if(searchSubfolders === true) {

			   async.eachOfLimit(list, 4, 
						// 2nd param is the function that each item is passed to
						function(runBlock, cnt, callback){

							var also = list[cnt];
							also += "/**";
							var uStartDir = upath.normalize(resolve(also));
							uStartDir = upath.relative(__dirname, uStartDir);
							if(winSharedDrive == true) {
								uStartDir = upath.relative(process.cwd(), uStartDir);
								//Double up the slashes.
								searchRel = searchRel.replace(/\//g, '\/\/');
							}
							
							if(verbose == true) console.log('Checking: ' + uStartDir);
							glob.readdir(uStartDir, { recurse: true, gitignore: true, nocase:true }, function(err, alsoList) {
								if(err) {
									callback(err);
								} else {
									//Add this to the master list
									if(verbose == true) console.log('Found 1st: ' + JSON.stringify(alsoList));

									thisMasterList = thisMasterList.concat(alsoList);
									thisMasterList = thisMasterList.filter(function(item, pos, self) {
										return self.indexOf(item) == pos;
									});
									callback(null);
								}
							});

						},	//End of async eachOf single item
					   function(err){
							// All tasks are done now
							if(err) {
							   console.log('ERR:' + err);
							   if(winSharedDrive == true) {
							   	  //Go back to the old folder
							  	  process.chdir(oldCwd);
							   }
							   cb(err, thisMasterList);
							 } else {
								cb(null, thisMasterList);
								if(verbose == true) console.log('Completed getting file created dates');
							}
					}

			);		//End of async.eachOf
		   }	//End of searchSubfolders check

		});  //nocase doesn't appear to work with this lib except for dir. See message above  nocase: true
	
	}
} else {
	//A unix style glob
	myGlob = function(searchAbs, options, cb) {
		var mg = new Glob(searchAbs, { "nocase": true }, cb);
	}
}




var globalId = "";


var masterConfigFile = __dirname + '/config/master.json';
var relImagePath = "../../photos";
var imagesStart = "/photos";
var mainMedImagePath = path.resolve(__dirname, relImagePath);		//An absolute path

if((typeof(globalConfig) !== 'undefined')  && globalConfig.backupTo && globalConfig.backupTo[0]) {
		
		/* OLD: we are always going to refer to the images in the MedImage main path.
		//Relative to this script
		mainMedImagePath = globalConfig.backupTo[0];
		
		//And imagesStart, which is relative to the current server directory
		if(isWin) {
			imagesStart = path.relative(process.cwd(),globalConfig.backupTo[0]) + "\\";		 
		} else {
			imagesStart = globalConfig.backupTo[0];
		}
		*/
		
		
		if(verbose == true) console.log("mainMedImagePath:" + mainMedImagePath);
		if(verbose == true) console.log("imagesStart:" + imagesStart);
}


var unallowedFilenameStrings = [
	".json",
	".wound-view.",
	".web-view.",
	".thumb",
	"Thumbs.db"
];



function trimChar(string, charToRemove) {
    while(string.substring(0,1) == charToRemove) {
        string = string.substring(1);
    }

    while(string.slice(-1) == charToRemove) {
        string = string.slice(0, -1);
    }

    return string;
}


function escapeRegExp(str) {
    return str.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
}

function normalizeInclWinNetworks(inpath, style)
{
	//Tests to see if the path is a Windows network path first, if so, handle this case slightly differently
	//to a normal upath.normalization.
	//style can be 'winstyle' i.e. back slashes if on Windows, or defaults to 'unixstyle' which is always forward slashes '/'
	if(!style) {
		var style = "unixstyle";	
	}
	
	//Run this before 
	if((inpath[0] == "\\")&&(inpath[1] == "\\")) {
		
		if(style == "winstyle") {
			return "\\" + path.normalize(inpath);		//Prepend the first slash
		} else {
			return "\/" + upath.normalize(inpath);		//Prepend the first slash
		}
	} else {
		if((inpath[0] == "\/")&&(inpath[1] == "\/")) {
			//In unix style syntax, but still a windows style network path
			if(style == "winstyle") {
				return "\/" + path.normalize(inpath);		//Prepend the first slash
			} else {
				return "\/" + upath.normalize(inpath);		//Prepend the first slash
			}
		} else {
			//Normal
			if(style == "winstyle") {
				return path.normalize(inpath);
			} else {
				return upath.normalize(inpath);
			}
		}
	}

}


function showLabel(str) {

	if(winSharedDrive == true) {
		str = targetDrive + str;
	}


	if(verbose == true) {
			console.log("showLabel() input is " + str);
	}
	str = normalizeInclWinNetworks(str);		//Convert to unix style path
	
	if(verbose == true) {
			console.log("After normalizer input is " + str + " imagesStart:" + imagesStart);
	}
	
	str = afterStr(str,imagesStart);
	
	if(verbose == true) {
			console.log("After normalizer and afterStr input is " + str);
	}
	
	//Replace last '/' with a space
	var firstPos = str.indexOf(pathSearcher);
	var pos = str.lastIndexOf(pathSearcher);
	if(pos != firstPos) {
		str = str.substring(0,pos) + ' ' + str.substring(pos+1);
	}
	
	//Now replace others with hashes for directories
	str = str.replace(/\//g, " #");
	str = str.replace(/\\/g, " #");		//Handle windows case also
	return str;
}

function showPath(str) {
	if(winSharedDrive == true) {
		str = targetDrive + str;
	}

	str = normalizeInclWinNetworks(str);		//Convert to unix style path
	str = afterStr(str,imagesStart);
	str = trimChar(str, pathSearcher);
	return str;
}


function getFileFromUserStr(inFile, capitalizeFirstWord)		//This was originally copied from the MedImage server.
{
		if(!capitalizeFirstWord) {
			var capitalizeFirstWord = false;
		}
		if(verbose == true) console.log("getFileFromUserStr:" + inFile);
		var outFile = inFile;

		outFile = outFile.replace('.jpg','');			//Remove jpg from filename
		outFile = outFile.replace('.jpeg','');			//Remove jpg from filename
		outFile = replaceAll(outFile, "..", "");			//Remove nasty chars


		outFile = trimChar(outFile, '/');		//Allowed directory slashes within the filename, but otherwise nothing around sides
		outFile = trimChar(outFile,'\\');



		var words = outFile.split(' ');		//This is different (a space here), it is directly from a user, not from the app

		if(verbose == true) console.log("Building up file:" + outFile);

		var finalFileName = "";
		var outhashdir = "";
		//Array of distinct words
		for(var cnt = 0; cnt< words.length; cnt++) {
			var thisWord = words[cnt].replace('#','');
			if(cnt < (words.length -1)) {		//First few words are directories in this version
				   

				   //Do some trimming of this directory name
					getDir = trimChar(thisWord, '/');
					getDir = trimChar(getDir, '\\');


				   if(verbose == true) console.log('Comparing ' + getDir + ' with ' + globalId);
				   if(getDir != globalId) {
					   outhashdir = outhashdir + '/' + getDir;
					   if(verbose == true) console.log('OutHashDir:' + outhashdir);
				    }
			} else {		//Last word is filename
				//Do some odd char trimming of this
				thisWord = trimChar(thisWord, '/');
				thisWord = trimChar(thisWord, '\\');

				//Start building back filename with hyphens between words
				if(finalFileName.length > 0) {
					finalFileName = finalFileName + '-';
				}
				finalFileName = finalFileName + thisWord;
			}
		}  //end of loop
		
	
	
	
	
		if(verbose == true) console.log("finalFileName:" + finalFileName);
		
		if(capitalizeFirstWord == true) {
			var words = finalFileName.split(" ");
			words[0] = words[0].toUpperCase();
			finalFileName = words.join(" ");	
			outhashdir = outhashdir.toUpperCase();		//uppercase the folder also.
			if(verbose == true) console.log("Capitalized first search word:" + finalFileName + " and capitalized folder:" + outhashdir);
		}
		
		
		
	
	
		if(finalFileName) {
			if(inFile.slice(-1) == ' ') {
				//End of a directory
				finalFileName = finalFileName + '/*';		//Trying ** instead of *
			} else {
				//Assume a word
				finalFileName = finalFileName + '*';
			}
			
			
			return normalizeInclWinNetworks(outhashdir + '/' + finalFileName, "winstyle");			//NB. path.normalize keeps Windows version of path, as opposed to upath
		} else {
			
			if(inFile.slice(-1) == ' ') {
				//End of a directory
				return normalizeInclWinNetworks(outhashdir + '/*', "winstyle");
			} else {
				//It is part way into a folder name
				return normalizeInclWinNetworks(outhashdir + '*', "winstyle");
			}
		}
}

function replaceAll(str, find, replace) {
  return str.replace(new RegExp(escapeRegExp(find), 'g'), replace);
}

function afterStr(str, searchFor)
{


	var c = str.indexOf(searchFor);
	if (c >= -1)
	{
		// Returns the portion not including the search string;
		// in this example, "Here is a <a>link". If you want the
		// search string included, add the length of the search
		// string to c.
		var start = c + searchFor.length;  //On Windows seems to need a +1 here? On unix, perhaps not?
		return str.substr(start);
		
	} else {
		return str;
	}

}


function fileWalk(startDir, sessionId, term, cb)   //This was originally copied from the MedImage server.
{
   //Read and return the first file in dir, and the count of which file it is. Only the cnt = 0 is used
   var items = [];

	if(verbose == true) console.log("Searching:" + startDir);
	//[ { "label": "#peter blister (10-June-2017 10:30am 56secs)", "value": "/peter/blister-10-June-2017-10-30-56.jpg" },
	//{ "label": "#peter blister (20-June-2017 10:40am 34secs)", "value": "/peter/blister-10-June-2017-10-40-34.jpg" }]
	
	
	var uStartDir = upath.normalize(resolve(startDir)); //readdir requires a unix style path
	var isWin = /^win/.test(platform);
	if(isWin) {
		uStartDir = uStartDir + "";			//Rely on our extra subdir search in the myGlob function for Windows searching
	} else {
		//Do a search of subdirectories also, linux style
		uStartDir = uStartDir + "/**";		//"*/*";  which creates term**/*, after the 'term' which is what is being typed.
	}
	
	//Note: on Windows an absolute path won't work - it needs to be relative to the script
	if(verbose == true) console.log("Searching in unix terms:" + uStartDir);
	
	myGlob(uStartDir, {"term": term}, function(err, list) {
		 
		 var resp = [];
		 resp.length = 0;		//Clear this
		 
		 //Get precise date formed 
		 var items = [];
		 for(var cnt = 0; cnt< list.length; cnt++) {
		 	 items[cnt] = {};
		 	 items[cnt].label = list[cnt];
		 	 if(verbose == true) console.log(list[cnt]);
		 }
		 
		 async.eachOf(items,
				// 2nd param is the function that each item is passed to
				function(runBlock, cnt, callback){
					fs.stat(items[cnt].label, function(err, stats){
						var ctime = new Date(stats.ctime);
						items[cnt].date = ctime;
						callback(null);
					});
					
				},	//End of async eachOf single item
			   function(err){
				// All tasks are done now
				if(err) {
				   console.log('ERR:' + err);
				 } else {
				   if(verbose == true) console.log('Completed getting file created dates');
				   
				   
				   
				   //Now proceed to sort them
			   		items.sort(function(a,b){
						// Turn your strings into dates, and then subtract them
						// to get a value that is either negative, positive, or zero.
						return new Date(b.date) - new Date(a.date);
					 });
			   
			   		
			   
			   		//And display them in the response
					for(var cnt = 0; cnt< items.length; cnt++) {
						var banned = false;
						//Now confirm it doesn't have any of the banned strings

						for(var scnt = 0; scnt < unallowedFilenameStrings.length; scnt++) {
							if(items[cnt].label.indexOf(unallowedFilenameStrings[scnt]) >= 0) {
								banned = true;
							}
						}
			 
						if(banned == false) { 
							 if(items[cnt].label.indexOf(".jpg") >= 0) {
								//Definitely a .jpg image file
								//Append to the list of user options to select
								resp.push({
									"label": showLabel(items[cnt].label),		//TODO: can make label prettier
									"value": showPath(items[cnt].label)
								});
					
								if(verbose == true) console.log("Found label:" + showLabel(items[cnt].label) + "   value:" + showPath(items[cnt].label));
				
							 } else {
								//A directory
								resp.push({
									"label": showLabel(items[cnt].label) + " (folder)",		//TODO: can make label prettier
									"value": showPath(items[cnt].label)
								});
					
								if(verbose == true) console.log("Found label:" + showLabel(items[cnt].label) + "   value:" + showPath(items[cnt].label));
				
			 
							 }
						 }  //end of banned
					}
					
					//Trim resp to the first 50 results
					resp = resp.slice(0, 50);
		
					items.length = 0;		//Clear off the items array for next call
					items = [];
					list.length = 0;
					list = [];
					cb(resp);
			   
			   
			   
			   
				   return;
				 }
			   }
		); //End of async eachOf all items			
		
		 
		 
		 
		 
		
		
	});
			        



}


function readConfig(confFile, cb) {
	//Reads and updates config with a newdir in the output photos - this will overwrite all other entries there
	//Returns cb(err) where err = null, or a string with the error


	//Write to a json file with the current drive.  This can be removed later manually by user, or added to
	fs.readFile(confFile, function read(err, data) {
		if (err) {
				cb(null, "Sorry, cannot read config file! " + err);
		} else {
			try {
				var content = JSON.parse(data);
			} catch (err) {
				cb(null, "Sorry, cannot read config file! " + err);
				return;
			}

			cb(content, null);
		};
	});

}



function doMultiSearch(term, sessionId, callback) {

	var thisCallback = callback;	
	
	//Write this array into the range calculation in the config file
	//Check if global config overrides path
	var platform = process.platform;
	var isWin = /^win/.test(platform);
	if(isWin) {
		var readPhotoFile = mainMedImagePath + getFileFromUserStr(term, false);  
		var resp = null;
		fileWalk(readPhotoFile, sessionId, term, function(resp) {
			
			var thisCallbackB = thisCallback;
			if((!resp)||(resp && resp.length <= 1)) {
				//No results - try a search for a capitalized version, instead
				var readPhotoFileB = mainMedImagePath + getFileFromUserStr(term, true); 
				fileWalk(readPhotoFileB, sessionId, term, function(respb) {
					var output =  "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(respb));  //TODO - check security issues on this
					//console.log(output);		

					var ret = {};
					ret.err = null;
					ret.stdout = output;
					ret.stderr = null;

					thisCallbackB(null, ret);
				});
			} else {
				//Yes, we got some results
				var output =  "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));  //TODO - check security issues on this
				//console.log(output);		

				var ret = {};
				ret.err = null;
				ret.stdout = output;
				ret.stderr = null;
	
				thisCallbackB(null, ret);
			
			}
		
		});
	
	} else {
		//Do a single filewalk
		
		var readPhotoFile = mainMedImagePath + getFileFromUserStr(term);  
		var resp = null;
		
		fileWalk(readPhotoFile, sessionId, term, function(resp) {

			var output =  "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));  //TODO - check security issues on this
			//console.log(output);		

			var ret = {};
			ret.err = null;
			ret.stdout = output;
			ret.stderr = null;
	
			thisCallback(null, ret);


		});
	}
}

	
	
module.exports = { 
	medImage : function(argv, callback) {

	
		var param = decodeURIComponent(argv[0]);
		var opts = queryString.parse(param);	
		
		if((!opts.term)||(opts.term == "")||(opts.term == "#")) {
			opts.term = "# ";		//Our search always starts with a hash
		}
		
		
			
		if((opts.sessionId) && (session.checkSessionValid(opts.sessionId) > -1)) {


			doMultiSearch(opts.term, opts.sessionId, callback);

			
		} else {
			//Not signed in
			var resp = {
						"label": "Please sign in.",		
						"value": ""
					};
			
			var output =  "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));  //TODO - check security issues on this
			
			var ret = {};
			ret.err = null;
			ret.stdout = output;
			ret.stderr = "You need to sign in.";
			
			callback(null, ret);
		}
	
	}	
}	
		   
	

