/*

MedImage Wound Analysis Add-on - Fine tune the colour ranges, and their parameters
==============================

Developed by (C) AtomJump Ltd. 10 Aug 2017. This is a commercial add-on to MedImage, and is licensed
by AtomJump on a per-server basis.

This takes several input parameters:

colourType = "Wound" or "Sticker"
scope = "global" or "photo"
id = colour range array member starting from 0 in the config file
photo = file/path/photo.jpg  (relative to MedImage photos folder)
act = "copy" or "delete" or "drawing" or any new option
points = freestyle drawing points, if any

*/


//OLDvar cv = require('opencv');
var fs = require('fs');
var fsExtra = require('fs-extra');
var upath = require('upath');
var queryString = require('querystring');
var path = require('path');
var area = require('area-polygon');
var resolve = require('path').resolve;




var verbose = false;		
var globalId = "";


var masterConfigFile = __dirname + '/config/master.json';
var mainMedImagePath = __dirname + "/../../photos";   //If run from two dirs in: "../../photos";
var globalConfigFile = __dirname + '/../../config.json';


//Include shared funcs
var normalizeInclWinNetworks = require(__dirname + '/common/libfuncs.js').normalizeInclWinNetworks;
var readConfig = require(__dirname + '/common/libfuncs.js').readConfig;
var writeConfig = require(__dirname + '/common/libfuncs.js').writeConfig;

//Include local library functions
var refresh = require(normalizeInclWinNetworks(__dirname + '/common/refresh-thumbnail.js')); 






function convertCoords(x, y, optswidth, optsheight, imwidth, imheight, zoomedIn, zc) {
	//Inputs coords in screen-view coords (i.e. (0 - 800) x (0 - 600) typically), and convert these
	//into coordinates of the source image (e.g. (0 - 3000ish) x (0 - 2000ish).
	//If the zoomedIn option is set to true, it means we are using a zoomed in version of the photo,
	//zoomedInCoords (zc) will be [left, right, top, bottom] in coordinates from the source image.
	
	//Coords are 0,0 top left of the image.

	if(zoomedIn == false) {
		var outx = (x * imwidth) / optswidth;
		var outy = (y * imheight) / optsheight;
					
		var newX = parseInt(outx);			//Note x/y were swapped around on purpose
		var newY = parseInt(outy);
		
		var retObj = {
			"newX": newX,
			"newY": newY	
		};
	} else {
		//Zoomed in version
		var outx = (((zc.right - zc.left) * x) / optswidth) + zc.left;
		var outy = (((zc.bottom - zc.top) * y) / optsheight) + zc.top;
		
		var newX = parseInt(outx);			//Note x/y were swapped around on purpose
		var newY = parseInt(outy);
		
		var retObj = {
			"newX": newX,
			"newY": newY	
		};
	}

	return retObj;
}






if(process.argv[2]) {

	

	var param = decodeURIComponent(process.argv[2]);

	param = param.replace("fine-tune/?","");

	var opts = queryString.parse(param);
	
	var sessionId = "";
	if(opts.sessionId) {
		sessionId = opts.sessionId;
	}	
	
	
	if(opts.photo) {
		var photoConfigFile = mainMedImagePath + opts.photo.replace(".jpg", ".json");
		var readConfigFile = photoConfigFile;
	} else {
		 var resp = {
	   	 	"completed": false,
	   	 	"error": "Photo parameter missing"	   	 
	   	 } 
		 console.log("You need to pass a photo file.");
		 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
		 process.exit(0);
	}
	
	
	if(opts.scope == "global") {
		readConfigFile = masterConfigFile;
		//But we will need to open and copy the master config from the destination folder to 
		//the local, if it exists in the individual options, below. E.g. "copy"
		
	
	} else {
		//Use the specific json file for the photo only
	
	}
	
	var writeConfigFile = readConfigFile;		//Defaults to the same file to write

	readConfig(readConfigFile, function(newConf, err) {

	   if(err) {
	   	 
	   	 var resp = {
	   	 	"completed": false,
	   	 	"error": err	   	 
	   	 } 
		 console.log("Error reading config file:" + err);
		 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
		 
	   } else {
	   		//We have read the config file
			
			//Change the config now
			
			var conf = newConf;		//Get local scope version
			
			switch(opts.act) {
				case "copy":
				
					//Read in the global config
					readConfig(globalConfigFile, function(globConf, err) {
						if(err) {
							//There was a problem loading the global config
							console.log("Error reading global config file:" + err);
							
							var resp = {
										"completed": false,
										"error": "Error reading global config file"	   	 
							} 
							console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
	
						
						} else {
						
							//With this global config, determine whether we should use a remote version
							if(globConf.backupTo && globConf.backupTo[0]) {
								//By default use the destination version, since that is shared. It sits in the home folder of the shared drive folder						
								
								var sharedMasterConfigFile = globConf.backupTo[0] + "/master.json"; 
								try {
								  if (fs.existsSync(sharedMasterConfigFile)) {
									//master file exists
									//And copy shared master down to local master
									try {
									  fsExtra.copySync(sharedMasterConfigFile, masterConfigFile);
									  console.log('Copied shared master ' + sharedMasterConfigFile + ' to local master ' + masterConfigFile + ', success!');
									} catch (err) {
									  console.error(err);
									}
								  } else {
								  	//doesn't exist, so local master will be backed up, also
								  	try {
									  fsExtra.copySync(masterConfigFile, sharedMasterConfigFile);
									  console.log('Shared local master config, success!');
									} catch (err) {
									  console.error(err);
									}
								  }
								} catch(err) {
								  console.error(err);
								}
								
								
								
							} else {
								//Otherwise use the local version
							}
							
							//More in here
							if(opts.scope == "global") {
								//Copying global entry to local photo config. Have global already in 'conf'. Need to load the other
								readConfigFile = photoConfigFile;
								writeConfigFile = photoConfigFile;
								
								//Have local master in 'conf', need to get global master!
								if(globConf.backupTo && globConf.backupTo[0]) {
									try {
										conf = JSON.parse(fs.readFileSync(sharedMasterConfigFile, 'utf8').toString());
									} catch (err) {
									  console.error(err);
									}
								}
								
							} else {
								//Copying local photo config entry to global config. Have photo conf already. Need to load the global
								readConfigFile = masterConfigFile;
								writeConfigFile = masterConfigFile;
								
								if(globConf.backupTo && globConf.backupTo[0]) {
									readConfigFile = sharedMasterConfigFile;
									writeConfigFile = sharedMasterConfigFile;
								}
								
					
							}
					
							if(opts.colourType == "Wound") {
								//Copy this entry in the array
								if(conf && conf.input && conf.input.wound && conf.input.wound.colourRanges) {
									var newRange = conf.input.wound.colourRanges[opts.id];
								} else {
									console.log("Error - the colour range configuration could not be read. Currently looking at:" + JSON.stringify(conf));
									var resp = {
										"completed": false,
										"error": "Sorry, the colour range configuration could not be read."	   	 
									 } 
									 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
									 process.exit(0);
								}
							} else {
								//Copy this entry in the array
								if(conf && conf.input && conf.input.sticker && conf.input.sticker.colourRanges) {
									var newRange = conf.input.sticker.colourRanges[opts.id];
								} else {
									console.log("Error - the colour range configuration could not be read. Currently looking at:" + JSON.stringify(conf));
									var resp = {
										"completed": false,
										"error": "Sorry, the colour range configuration could not be read."	   	 
									 } 
									 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
									 process.exit(0);
								}
							}
					
					
							//Get the file we're adding to
						   readConfig(readConfigFile, function(copyToConf, err) {
							   if(err) {
								 var resp = {
									"completed": false,
									"error": err	   	 
								 } 
								 console.log("Error reading config file:" + err);
								 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
	 
							   } else {
					   
									//Push into the array
									if(opts.colourType == "Wound") {
										//Copy this entry in the array
										var existingRanges = copyToConf.input.wound.colourRanges;
									} else {
										//Copy this entry in the array
										var existingRanges = copyToConf.input.sticker.colourRanges;
									}
							
									//Check there isn't this range in there already - see https://stackoverflow.com/questions/1068834/object-comparison-in-javascript
									var strNewRange = JSON.stringify(newRange);
									for(var cnt = 0; cnt< existingRanges.length; cnt++) {
								
								
										if(JSON.stringify(existingRanges[cnt]) === strNewRange) {
											 var resp = {
												"completed": false,
												"error": "Sorry, this colour range already exists there."	   	 
											 } 
											 console.log("Error writing config file:" + err);
											 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
											 process.exit(0);
								
										}
							
									}
							
									//Otherwise lets push the new range
									existingRanges.push(newRange);
						
									//And save the config file again	   		
									writeConfig(writeConfigFile, copyToConf, function(err) {
										if(err) {
											 var resp = {
												"completed": false,
												"error": err	   	 
											 } 
											 console.log("Error writing config file:" + err);
											 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
										} else {
											//Success!
											var act = opts.act + " " + opts.colourType + " " + opts.id;
											var resp = {
												"completed": true,
												"error": null,
												"action": act	   	 
											 } 
											 if(writeConfigFile == sharedMasterConfigFile) {
											 	//Want to do the backup of this file ourselves - because it isn't in the normal
											 	//folders. 
											 	//Copy global master down to local master
												try {
												  fsExtra.copySync(sharedMasterConfigFile, masterConfigFile);
												  console.log('Backing up global master ' + sharedMasterConfigFile  + ' to local ' + masterConfigFile + ' success!');
												} catch (err) {
												  console.error(err);
												}
												//No need for a backupFiles signal to the main parent MedImage
											 } else {
											 	if(writeConfigFile == masterConfigFile) {
											 		//Save it up as the global master
											 		try {
													  fsExtra.copySync(masterConfigFile, sharedMasterConfigFile);
													  console.log('Backing up master ' + masterConfigFile  + '  to global master ' + sharedMasterConfigFile + ' success!');
													} catch (err) {
													  console.error(err);
													}
											 	} else {
											 	
											 		//OLD way, now have local cache: console.log("backupFiles:" + resolve(writeConfigFile));
											 	}
											 }
											console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));		
										}
									});
					
					
								}
							});
							
							
							
							
						} //End of error on loading global config
					});	//End of reading global config file	
							
						
				
					
				
				
				break;
				
				
				
				case "check-messaging":
					//Check messaging status
					if(conf.output && conf.output.ajServer) {
						var resp = {
									"completed": true,
									"error": null,
									"ajServer": conf.output.ajServer,
									"ajForum": conf.output.ajRoot,
									"ajCSS": conf.output.ajCSS,
									"ajJS": conf.output.ajJS,
									"ajBaseCSS": conf.output.ajBaseCSS,
									"ajMachineUser" : conf.output.ajMachineUser,
									"ajDomain": conf.output.ajDomain,
									"action": "Have messaging"	   	 
								 } 
						console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
					
					} else {
						var resp = {
									"completed": true,
									"error": null,
									"ajServer": "",
									"ajForum": "",
									"ajCSS": "",
									"ajJS": "",
									"ajBaseCSS": "",
									"ajMachineUser" : "",
									"ajDomain": "",									
									"action": "No messaging"	   	 
								 } 
						console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
					
					}
									
				
				break;
				
				
				case "delete":
					//Deleting colour range
					
					//Read in the global config
					readConfig(globalConfigFile, function(globConf, err) {
						if(err) {
							//There was a problem loading the global config
							console.log("Error reading global config file:" + err);
							
							var resp = {
										"completed": false,
										"error": "Error reading global config file"	   	 
							} 
							console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
	
						
						} else {
						
							//With this global config, determine whether we should use a remote version
							if(globConf.backupTo && globConf.backupTo[0]) {
								//By default use the destination version, since that is shared. It sits in the home folder of the shared drive folder						
								
								var sharedMasterConfigFile = globConf.backupTo[0] + "/master.json"; 
								try {
								  if (fs.existsSync(sharedMasterConfigFile)) {
									//master file exists
									//And copy shared master down to local master
									try {
									  fsExtra.copySync(sharedMasterConfigFile, masterConfigFile);
									  console.log('Copied shared master ' + sharedMasterConfigFile + ' to local master ' + masterConfigFile + ', success!');
									} catch (err) {
									  console.error(err);
									}
								  } else {
								  	//doesn't exist, so local master will be backed up, also
								  	try {
									  fsExtra.copySync(masterConfigFile, sharedMasterConfigFile);
									  console.log('Shared local master config, success!');
									} catch (err) {
									  console.error(err);
									}
								  }
								} catch(err) {
								  console.error(err);
								}
							}  //end of shared config if	
								
							//More here
									
							//We already have the scope defined by the config - so deleting within this config
							if(opts.colourType == "Wound") {
								//Remove this entry in the array
								conf.input.wound.colourRanges.splice(opts.id, 1);
							} else {
								//Remove this entry in the array
								conf.input.sticker.colourRanges.splice(opts.id, 1);
							}
							
							//Now create a new array without any gaps. See  See https://stackoverflow.com/questions/281264/remove-empty-elements-from-an-array-in-javascript
							conf.input.sticker.colourRanges = conf.input.sticker.colourRanges.filter(x => x);
				
							//And save the config file again	   		
							writeConfig(writeConfigFile, conf, function(err) {
								if(err) {
									 var resp = {
										"completed": false,
										"error": err	   	 
									 } 
									 console.log("Error writing config file:" + err);
									 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
								} else {
									//Success!
									var act = opts.act + " " + opts.colourType + " " + opts.id;
									var resp = {
										"completed": true,
										"error": null,
										"action": act	   	 
									 } 

									 if(writeConfigFile == sharedMasterConfigFile) {
										//Want to do the backup of this file ourselves - because it isn't in the normal
										//folders. 
										//Copy global master down to local master
										try {
										  fsExtra.copySync(sharedMasterConfigFile, masterConfigFile);
										  console.log('Backing up global master ' + sharedMasterConfigFile  + ' to local ' + masterConfigFile + ' success!');
										} catch (err) {
										  console.error(err);
										}
										//No need for a backupFiles signal to the main parent MedImage
									 } else {
										if(writeConfigFile == masterConfigFile) {
											//Save it up as the global master
											try {
											  fsExtra.copySync(masterConfigFile, sharedMasterConfigFile);
											  console.log('Backing up master ' + masterConfigFile  + '  to global master ' + sharedMasterConfigFile + ' success!');
											} catch (err) {
											  console.error(err);
											}
										} else {
										
											//OLD way now have local cache:console.log("backupFiles:" + resolve(writeConfigFile));
										}
									 }


									 
									console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));		
								}
							});								
								
							
						} //end of read global else config 
					});	//end of global config
								
					
					
					
					
			
				
				break;
				
				case 'change-wound-type':
					conf.output.woundType = opts.woundType;
					
					
					//And save the config file again	   		
					writeConfig(writeConfigFile, conf, function(err) {
						if(err) {
							 var resp = {
								"completed": false,
								"error": err	   	 
							 } 
							 console.log("Error writing config file:" + err);
							 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
						} else {
							//Success!
							var act = opts.woundType;
							var resp = {
								"completed": true,
								"error": null,
								"action": act	   	 
							 } 
 	
 							 //OLD way now have local cache: console.log("backupFiles:" + resolve(writeConfigFile));
							console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));		
						}
					});
				
				break;
				
				case "drawing":
					
					//Effectively a 'save' of a drawing
					//WARNING: this is now redundant and is held in the fine-tune-large.js file in RAM.
					//This was because a large saved area with lots of hand drawings could fairly easily overrun
					//the 8K command line limit of Windows. Therefore it now runs directly.
					if(verbose == true) console.log("Opts:" + JSON.stringify(opts));
					
					if(!conf.output.areas)	{
						conf.output.areas = [];					
					}
					
					try {

    					var areas = JSON.parse(opts.areas);

  					} catch (e) {
  							var resp = {
								"completed": false,
								"error":  JSON.stringify(e)	   	 
							 } 
							 console.log("Error parsing area data: " + JSON.stringify(e));
							 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
							 return;
  					}
					
					
					
					
					conf.output.areas = areas;
					
					//Recalc the drawing area
					conf = refresh.calculateDrawingArea(conf);
					
					if((conf) && (conf.output) && (conf.output.fullWound) && (conf.output.fullWound.underAreaSquareCm)) {
							  		
						var underminingArea = conf.output.fullWound.underAreaSquareCm;
						var underminingAreaStr = ".<span style=\"color: #888;\"> External <i class=\"fa fa-pie-chart\"></i>  <span id=\"total-area\">" + conf.output.fullWound.woundAreaSquareCm + "</span> cm<sup>2</sup>.  Undermining <i class=\"fa fa-pie-chart\"></i>  <span id=\"total-area\">" + underminingArea + "</span> cm<sup>2</sup></span>";
				   } else {
						var underminingAreaStr = "";
				   }
					
					
					//And save the config file again	   		
					writeConfig(writeConfigFile, conf, function(err) {
						if(err) {
							 var resp = {
								"completed": false,
								"error": err	   	 
							 } 
							 console.log("Error writing config file:" + err);
							 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
						} else {
							//Success!
							
							var resp = {
								"completed": true,
								"error": null,
								"action": "Added drawing",
								"area": conf.output.fullWound.areaSquareCm,
								"underArea": underminingAreaStr	   	 
							 } 
							//OLD way, now have local cache: console.log("backupFiles:" + resolve(writeConfigFile));
							console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));		
						}
					});
				
				break;
				
				
				
				case "delete-photo":
				
					var writeConfigFileInner = writeConfigFile;
			
					//Read in the global config
					readConfig(globalConfigFile, function(globConf, err) {
						if(err) {
							//There was a problem loading the global config
							console.log("Error reading global config file:" + err);
							
							var resp = {
										"completed": false,
										"error": "Error reading global config file"	   	 
							} 
							console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
	
						
						} else {
			
							if(verbose == true) console.log("Read global config OK. thisCb:" + JSON.stringify(thisCb));
			
							
			
			
							if(writeConfigFileInner != masterConfigFile) {
								//Do the C:\MEDIMAGE\PHOTOS version
								console.log("Deleting " + writeConfigFileInner);
								fs.unlinkSync(writeConfigFileInner);
								
								var deleteCmd = writeConfigFileInner.replace(".json", "");
					
								if(conf.output && conf.output.nameConvention) {
									if(conf.output.nameConvention.replaceText) {
										console.log("Deleting " + deleteCmd + conf.output.nameConvention.replaceText);
										fs.unlinkSync(deleteCmd + conf.output.nameConvention.replaceText);
									}
						
									//Keep this for historic Nurse Maude case, but future installs won't have a .withWoundText
									if(conf.output.nameConvention.withWoundText) {
										console.log("Deleting " + deleteCmd + conf.output.nameConvention.withWoundText);
										fs.unlinkSync(deleteCmd + conf.output.nameConvention.withWoundText);
									}
						
									if(conf.output.nameConvention.withThumbnailText) {
										console.log("Deleting " + deleteCmd + conf.output.nameConvention.withThumbnailText);
										fs.unlinkSync(deleteCmd + conf.output.nameConvention.withThumbnailText);
									}
						
									if(conf.output.nameConvention.withWebViewText) {
										console.log("Deleting " + deleteCmd + conf.output.nameConvention.withWebViewText);
										fs.unlinkSync(deleteCmd + conf.output.nameConvention.withWebViewText);
									}
								} else {
						
									//Now no longer in the local cache:console.log("Deleting " + deleteCmd + ".jpg");
									//fs.unlinkSync(deleteCmd + ".jpg");
						
									console.log("Deleting " + deleteCmd + ".thumbnail.jpg");
									fs.unlinkSync(deleteCmd + ".thumbnail.jpg");
						
									console.log("Deleting " + deleteCmd + ".web-view.jpg");
									fs.unlinkSync(deleteCmd + ".web-view.jpg");
							
						
								}
								
								
								//Check if there are any files left in this folder, and delete the folder if not.
								var checkFolder = path.dirname(normalizeInclWinNetworks(writeConfigFileInner)); 
								console.log("Checking " + checkFolder + " async - no console output");
								fs.readdir(checkFolder, function(err, files) {
									if(!err) {
										//Warning: don't display any console activity here - this will disrupt
										//the output from the main deletion since it is asnyc
										//console.log("Directory has " + files.length + " files in it still.");
										if(files.length == 0) {
											//An empty directory - delete the folder
											//console.log("Deleting " + checkFolder);
											fs.rmdir(checkFolder, function(err) {
												//No console in here
											});
										}
									} else {
										//console.log("Error checking folder: " + err);
									}
								});
								
								
								
								//Do the backupTo version
								
								if(globConf.backupTo && globConf.backupTo[0]) {
									var writeConfigFile = globConf.backupTo[0] + opts.photo.replace(".jpg", ".json");
							
									console.log("Backup version: " + writeConfigFile);
									if(normalizeInclWinNetworks(writeConfigFileInner) != normalizeInclWinNetworks(writeConfigFile)) {	//It isn't the same path as the original deleted photo above
									
										//Now no longer in the local cache:console.log("Deleting " + writeConfigFile);
										//Now no longer in the local cache:fs.unlinkSync(writeConfigFile);
										var deleteCmd = writeConfigFile.replace(".json", "");
					
										if(conf.output && conf.output.nameConvention) {
											if(conf.output.nameConvention.replaceText) {
												console.log("Deleting " + deleteCmd + conf.output.nameConvention.replaceText);
												fs.unlinkSync(deleteCmd + conf.output.nameConvention.replaceText);
											}
						
											//Keep this for historic Nurse Maude case, but future installs won't have a .withWoundText
											if(conf.output.nameConvention.withWoundText) {
												console.log("Deleting " + deleteCmd + conf.output.nameConvention.withWoundText);
												fs.unlinkSync(deleteCmd + conf.output.nameConvention.withWoundText);
											}
						
											if(conf.output.nameConvention.withThumbnailText) {
												console.log("Deleting " + deleteCmd + conf.output.nameConvention.withThumbnailText);
												fs.unlinkSync(deleteCmd + conf.output.nameConvention.withThumbnailText);
											}
						
											if(conf.output.nameConvention.withWebViewText) {
												console.log("Deleting " + deleteCmd + conf.output.nameConvention.withWebViewText);
												fs.unlinkSync(deleteCmd + conf.output.nameConvention.withWebViewText);
											}
										} else {
						
											console.log("Deleting " + deleteCmd + ".jpg");
											fs.unlinkSync(deleteCmd + ".jpg");
						
											//Now only in the local cache:console.log("Deleting " + deleteCmd + ".thumbnail.jpg");
											//Now only in the local cache:fs.unlinkSync(deleteCmd + ".thumbnail.jpg");
						
											//Now only in the local cache:console.log("Deleting " + deleteCmd + ".web-view.jpg");
											//Now only in the local cache:fs.unlinkSync(deleteCmd + ".web-view.jpg");
							
						
										}
										
										//Check if there are any files left in this folder, and delete the folder if not.
										var checkFolder = path.dirname(normalizeInclWinNetworks(writeConfigFile)); 
										console.log("Checking " + checkFolder + " async - no console output");
										fs.readdir(checkFolder, function(err, files) {
											if(!err) {
												//Warning: don't display any console activity here - this will disrupt
												//the output from the main deletion since it is asnyc
												//console.log("Directory has " + files.length + " files in it still.");
												if(files.length == 0) {
													//An empty directory - delete the folder
													//console.log("Deleting " + checkFolder);
													fs.rmdir(checkFolder, function(err) {
														//No console in here
													});
												}
											} else {
												//console.log("Error checking folder: " + err);
											}
										});
										
										
									}
								}
								
					
								var resp = {
											"completed": true,
											"error": null,
											"action": "Deleted photo"	   	 
										 } 
								console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
								//Warning: don't put any non-sync file functions above, because they will corrupt the returned data.	
							} else {
								var resp = {
										"completed": false,
										"error": "Trying to remove the master file"	   	 
									 } 
									 console.log("Error: trying to remove the master file");
									 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
					
							}
						}
					});	
					
				
				break;
				
				case "refresh-thumbnail":
					//This function has now moved into it's own file /refresh-thumbnail.js
					/*
					var photoFile = mainMedImagePath + opts.photo;
					var webPhotoFile = photoFile.replace(conf.output.scaledPhoto.nameConvention.replaceText, 
												conf.output.scaledPhoto.nameConvention.withWebViewText);
					refresh.refreshThumbnail(cv, photoFile, webPhotoFile, conf, function(err, thumbnailFile) {
					
						console.log("backupFiles:" + resolve(thumbnailFile));
					
						var resp = {
									"completed": true,
									"error": null,
									"action": "Refreshed thumbnail photo"	   	 
								 } 
						console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
					
					}); 
					*/				
				
				break;
				
				
				case "zoom-out":
					
					//Clear object
					conf.input.zoomedInOrigCoords = {};
				
					//And save the config file again	   		
					writeConfig(writeConfigFile, conf, function(err) {
						if(err) {
							 var resp = {
								"completed": false,
								"error": err	   	 
							 } 
							 console.log("Error writing config file:" + err);
							 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
						} else {
							//Success!
							
							var resp = {
								"completed": true,
								"error": null,
								"action": "Added drawing"	   	 
							 } 
							 //OLD way before local cache:console.log("backupFiles:" + resolve(writeConfigFile));		//TODO: not sure about this one? Should it be in here?
							console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));		
						}
					});
				
				break;
				
				case "group-overwrite":
				case "group":
					//Group the colour ranges in this scope into a single new colour range, with 
					//the min/max in terms of hsv from all of them. Keep the original set.
					//We already have the scope defined by the config - so deleting within this config
					/*if(opts.scope == "global") {
						//Changing global conf. Have global already in 'conf'. 
						readConfigFile = masterConfigFile;
						writeConfigFile = masterConfigFile;
					} else {
						//Changing photo conf. Have photo conf already in 'conf'. 
						readConfigFile = photoConfigFile;
						writeConfigFile = photoConfigFile;
				
					}*/
					
									//Read in the global config
					readConfig(globalConfigFile, function(globConf, err) {
						if(err) {
							//There was a problem loading the global config
							console.log("Error reading global config file:" + err);
							
							var resp = {
										"completed": false,
										"error": "Error reading global config file"	   	 
							} 
							console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
	
						
						} else {
						
							//With this global config, determine whether we should use a remote version
							if(globConf.backupTo && globConf.backupTo[0]) {
								//By default use the destination version, since that is shared. It sits in the home folder of the shared drive folder						
								
								var sharedMasterConfigFile = globConf.backupTo[0] + "/master.json"; 
								try {
								  if (fs.existsSync(sharedMasterConfigFile)) {
									//master file exists
									//And copy shared master down to local master
									try {
									  fsExtra.copySync(sharedMasterConfigFile, masterConfigFile);
									  console.log('Copied shared master ' + sharedMasterConfigFile + ' to local master ' + masterConfigFile + ', success!');
									} catch (err) {
									  console.error(err);
									}
								  } else {
								  	//doesn't exist, so local master will be backed up, also
								  	try {
									  fsExtra.copySync(masterConfigFile, sharedMasterConfigFile);
									  console.log('Shared local master config, success!');
									} catch (err) {
									  console.error(err);
									}
								  }
								} catch(err) {
								  console.error(err);
								}
							}  //end of shared config if	
							
							
							//More here
								
							
					
					
					
				   
				   
							if(opts.colourType == "Wound") {
								var ranges = conf.input.wound.colourRanges;
							} else {
									//Copy this entry in the array
								var ranges = conf.input.sticker.colourRanges;
							}
		
							var newRange = JSON.parse(JSON.stringify(ranges[0]));	//Create a fresh copy with the stringify/parse

							//We must have an existing first colour range at least.
							if(newRange) {

								//Loop through each wound colour range, and get the min and max
								var minHSV = [ 255, 255, 255 ];
								var maxHSV = [ 0, 0, 0 ];
								for(var cnt = 0; cnt< ranges.length; cnt++) {
									for(hsvcnt = 0; hsvcnt < 3; hsvcnt++) { 
										if(ranges[cnt].lowerHSV[hsvcnt] < minHSV[hsvcnt]) minHSV[hsvcnt] = ranges[cnt].lowerHSV[hsvcnt];
										if(ranges[cnt].upperHSV[hsvcnt] > maxHSV[hsvcnt]) maxHSV[hsvcnt] = ranges[cnt].upperHSV[hsvcnt];
									}
								}

								//TODO - consider putting some HSV padding around these colours in here?

								//Overwrite the first range with the new min and max
								newRange.lowerHSV = minHSV;
								newRange.upperHSV = maxHSV;
					
	   
	   
	   
								//Push into the array
								if(opts.colourType == "Wound") {
									//Copy this entry in the array
									var existingRanges = conf.input.wound.colourRanges;
								} else {
									//Copy this entry in the array
									var existingRanges = conf.input.sticker.colourRanges;
								}
		
								//Check there isn't this range in there already - see https://stackoverflow.com/questions/1068834/object-comparison-in-javascript
								var strNewRange = JSON.stringify(newRange);
								for(var cnt = 0; cnt< existingRanges.length; cnt++) {
			
									//console.log("Comparing with: " + JSON.stringify(existingRanges[cnt]));
						
									if(JSON.stringify(existingRanges[cnt]) === strNewRange) {
										 var resp = {
											"completed": false,
											"error": "Sorry, this colour range already exists there."	   	 
										 } 
										 console.log("Error writing config file:" + err);
										 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
										 process.exit(0);
			
									}
		
								}
		
								//Otherwise lets push the new range
								//console.log("Action: " + opts.act);
								if(opts.act === "group-overwrite") {
									existingRanges.splice(0, existingRanges.length);		//Remove all current entries
									//console.log("About to insert:" + JSON.stringify(newRange));
								
									//Now create a new array without any gaps. See https://stackoverflow.com/questions/281264/remove-empty-elements-from-an-array-in-javascript
									existingRanges = existingRanges.filter(x => x);
								}
					
								existingRanges.push(newRange);
								
								if(opts.colourType == "Wound") {
                                    //Copy this entry in the array
                                    conf.input.wound.colourRanges = existingRanges;
                                } else {
                                    //Copy this entry in the array
                                    conf.input.sticker.colourRanges = existingRanges;
                                }
	
								//And save the config file again	   		
								writeConfig(writeConfigFile, conf, function(err) {
									if(err) {
										 var resp = {
											"completed": false,
											"error": err	   	 
										 } 
										 console.log("Error writing config file:" + err);
										 console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
									} else {
										//Success!
										var act = opts.act + " " + opts.colourType + " " + opts.id;
										var resp = {
											"completed": true,
											"error": null,
											"action": act	   	 
										 } 
										
										if(writeConfigFile == sharedMasterConfigFile) {
											//Want to do the backup of this file ourselves - because it isn't in the normal
											//folders. 
											//Copy global master down to local master
											try {
											  fsExtra.copySync(sharedMasterConfigFile, masterConfigFile);
											  console.log('Backing up global master ' + sharedMasterConfigFile  + ' to local ' + masterConfigFile + ' success!');
											} catch (err) {
											  console.error(err);
											}
											//No need for a backupFiles signal to the main parent MedImage
										 } else {
											if(writeConfigFile == masterConfigFile) {
												//Save it up as the global master
												try {
												  fsExtra.copySync(masterConfigFile, sharedMasterConfigFile);
												  console.log('Backing up master ' + masterConfigFile  + '  to global master ' + sharedMasterConfigFile + ' success!');
												} catch (err) {
												  console.error(err);
												}
											} else {
									
												//OLD way now have cache: console.log("backupFiles:" + resolve(writeConfigFile));
											}
										 }
										 
										 
										 
										console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));		
									}
								});
							}		//End of if(newRange)
					
						} //end of read global else config 
					});	//end of global config
						
				
				break;
							
			}
			
			
			
			
				   
	   		
	   
	   }
		
	});


	


	
} else {
	console.log("Usage: e.g. fine-tune.js ?type=Wound&scope=global&id=3  but urlencoded");

}

	

	   


