/*

MedImage Wound Analysis Add-on - This is a repeat of fine-tune.js but built to be in-memory, so that a larger file than 8K can be stored on Windows.
==============================

Developed by (C) AtomJump Ltd. 14 Nov 2019. This is a commercial add-on to MedImage, and is licensed
by AtomJump on a per-server basis.


*/


/*OLD var cv = require('opencv');
var fs = require('fs');
var upath = require('upath');
var path = require('path');
var queryString = require('querystring');*/

//OLDvar cv = require('opencv');
var fs = require('fs');
var fsExtra = require('fs-extra');
var upath = require('upath');
var queryString = require('querystring');
var path = require('path');
var area = require('area-polygon');
var resolve = require('path').resolve;



var session = require('../basic-authentication/session.js');


var verbose = false;		
var globalId = "";


// fine-tune.js version: 
var masterConfigFile = __dirname + '/config/master.json';
var mainMedImagePath = __dirname + "/../../photos";   //If run from two dirs in: "../../photos";
var globalConfigFile = __dirname + '/../../config.json';



//Include shared funcs
var normalizeInclWinNetworks = require(__dirname + '/common/libfuncs.js').normalizeInclWinNetworks;
var readConfig = require(__dirname + '/common/libfuncs.js').readConfig;
var writeConfig = require(__dirname + '/common/libfuncs.js').writeConfig;

//Include local library functions
var refresh = require(normalizeInclWinNetworks(__dirname + '/common/refresh-thumbnail.js')); 



module.exports = { 
	medImage : function(argv, callback) {

		


		if(argv[0]) {

	

			var param = decodeURIComponent(argv[0]);

			param = param.replace("fine-tune-large/?","");

			var opts = queryString.parse(param);
	
			var sessionId = "";
			if(opts.sessionId) {
				sessionId = opts.sessionId;
			}	
	
	
			if(opts.photo) {
				var photoConfigFile = mainMedImagePath + opts.photo.replace(".jpg", ".json");
				var readConfigFile = photoConfigFile;
			} else {
				 var resp = {
					"completed": false,
					"error": "Photo parameter missing"	   	 
				 } 
				 //console.log("You need to pass a photo file.");
				 //console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
				 var output = "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));
									
				 var ret = {};
				 ret.err = null;
				 ret.stdout = output;
				 ret.stderr = "Photo parameter missing";
				 callback(null, ret);
				 return;
			}
	
	
			if(opts.scope == "global") {
				readConfigFile = masterConfigFile;
				//But we will need to open and copy the master config from the destination folder to 
				//the local, if it exists in the individual options, below. E.g. "copy"
		
	
			} else {
				//Use the specific json file for the photo only
	
			}
	
			var writeConfigFile = readConfigFile;		//Defaults to the same file to write

			readConfig(readConfigFile, function(newConf, err) {

			   if(err) {
		 
				 var resp = {
					"completed": false,
					"error": err	   	 
				 } 
				 //console.log("Error reading config file:" + err);
				 //console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
				 var output = "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));
									
				 var ret = {};
				 ret.err = null;
				 ret.stdout = output;
				 ret.stderr = JSON.stringify(err)	;
				 callback(null, ret);
		 
			   } else {
					//We have read the config file
			
					//Change the config now
			
					var conf = newConf;		//Get local scope version

					switch(opts.act) {
						case "drawing":
						
							
							//Effectively a 'save' of a drawing
							if(verbose == true) console.log("Opts:" + JSON.stringify(opts));
					
							if(!conf.output.areas)	{
								conf.output.areas = [];					
							}
					
							try {

								var areas = JSON.parse(opts.areas);

							} catch (e) {
									var resp = {
										"completed": false,
										"error":  JSON.stringify(e)	   	 
									 } 
									 //console.log("Error parsing area data: " + JSON.stringify(e));
									 //console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
									 var output = "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));
									
									 var ret = {};
									 ret.err = null;
									 ret.stdout = output;
									 ret.stderr = JSON.stringify(e)	;
									 callback(null, ret);
									 return;
							}
					
					
					
					
							conf.output.areas = areas;
					
							//Recalc the drawing area
							conf = refresh.calculateDrawingArea(conf);
					
							if((conf) && (conf.output) && (conf.output.fullWound) && (conf.output.fullWound.underAreaSquareCm)) {
									
								var underminingArea = conf.output.fullWound.underAreaSquareCm;
								var underminingAreaStr = ".<span style=\"color: #888;\"> External <i class=\"fa fa-pie-chart\"></i>  <span id=\"total-area\">" + conf.output.fullWound.woundAreaSquareCm + "</span> cm<sup>2</sup>.  Undermining <i class=\"fa fa-pie-chart\"></i>  <span id=\"total-area\">" + underminingArea + "</span> cm<sup>2</sup></span>";
						   } else {
								var underminingAreaStr = "";
						   }
					
					
							//And save the config file again	   		
							writeConfig(writeConfigFile, conf, function(err) {
								if(err) {
									 var resp = {
										"completed": false,
										"error": err	   	 
									 } 
									 //console.log("Error writing config file:" + err);
									 //console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
									 var output = "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));
									
									 var ret = {};
									 ret.err = null;
									 ret.stdout = output;
									 ret.stderr = JSON.stringify(err)	;
									 callback(null, ret);
									 return;
									 
								} else {
									//Success!
							
									var resp = {
										"completed": true,
										"error": null,
										"action": "Added drawing",
										"area": conf.output.fullWound.areaSquareCm,
										"underArea": underminingAreaStr	   	 
									 } 
									//console.log("backupFiles:" + resolve(writeConfigFile));
									//console.log("returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp)));
									//"backupFiles:" + resolve(writeConfigFile) + "\n" +        //No longer needed because always using cache
									var output = "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));
									
									 var ret = {};
									 ret.err = null;
									 ret.stdout = output;
									 ret.stderr = "";
									 callback(null, ret);
									 return;		
								}
							});
				
						break;
					}
	   	
				}
		
		   });


	


	
		} else {
				console.log("Usage: e.g. fine-tune.js ?type=Wound&scope=global&id=3  but urlencoded");

		}





		/*
		   var param = decodeURIComponent(argv[0]);
		   var opts = queryString.parse(param);	
		   var testing = true;
			
		   if((session.checkSessionValid(opts.medimageSessionId) > -1)||(testing == true)) {
 				//We have permission to show messaging
				
				
		   } else {
		   		//Not logged in - don't show any photo, other than a login photo
			
				
				//Not signed in
				var resp = {
							"label": "Please sign in.",		
							"value": ""
						};
			
				var output =  "returnParams:?CUSTOMJSON=" + encodeURIComponent(JSON.stringify(resp));  //TODO - check security issues on this
			
				var ret = {};
				ret.err = null;
				ret.stdout = output;
				ret.stderr = "You need to sign in.";
			
				callback(null, ret);
				
		   
		   }
		   
		   */
	
	}	
}	


