/*

	Export all data from the Wound add-on (minus the pictures) to a CSV file

*/

var fs = require('fs');
var upath = require('upath');
var queryString = require('querystring');
var fsExtra = require('fs-extra');
var path = require('path');
var glob = require('glob');
var async = require('async');
var resolve = require('path').resolve;

var session = require('../basic-authentication/session.js');



var globalConfigFile = __dirname + '/../../config.json';
var masterConfigFile = __dirname + '/config/master.json';
var relImagePath = "../../photos";		//relative to this script
var mainMedImagePath = path.relative(process.cwd(), __dirname + '/' + relImagePath);
var medPhotosRelativePath = "photos/";
var imagesStart = "/photos";				//
var thumbnailString = ".thumbnail.";		//The default values from the master config - to be used when we can't load the master config for some reason
var replaceText = ".jpg";					//The default values from the master config - to be used when we can't load the master config for some reason
var withWebViewText =  ".web-view.jpg";		//The default values from the master config - to be used when we can't load the master config for some reason


var firstLine = "Filename,Id,Subfolder,WoundName,AreaSqCm,WoundType,ExternalSqCm,UnderminingSqCm,ImprovePerc,Period,Status,ExternalImprovePerc,UnderminingImprovPerc,ServerDateTime\r\n";
global.csvData = firstLine;


var verbose = false;


//Include shared funcs
var normalizeInclWinNetworksStyle = require(__dirname + '/common/libfuncs.js').normalizeInclWinNetworksStyle;
var readConfig = require(__dirname + '/common/libfuncs.js').readConfig;
var writeConfig = require(__dirname + '/common/libfuncs.js').writeConfig;




//Note: difference here from get-photos is we don't have the master config loaded. So we will do that below and modify the default paths

function rearrangePaths(globalConfig) {
		
		//Relative to this script
		if(globalConfig.backupTo && globalConfig.backupTo[0]) {
			mainMedImagePath = path.relative(process.cwd(), globalConfig.backupTo[0]);
		
			//And imagesStart, which is relative to the current server directory
			if(isWin) {
				imagesStart = normalizeInclWinNetworksStyle(path.relative(process.cwd(),globalConfig.backupTo[0]));		 
			} else {
				imagesStart = globalConfig.backupTo[0];
			}
		
		} else {
			if(isWin) {
			
			
			} else {
				//Linux with a 'null' backupTo, this should point at a relative path
				imagesStart = medPhotosRelativePath; 
			
			}
			
			
		}
		
		if(verbose == true) console.log("mainMedImagePath:" + mainMedImagePath);
		if(verbose == true) console.log("imagesStart:" + imagesStart);
		
		return;
}

//Create a platform unspecific globber called myGlob(absolutepath, cb(err, list));
var platform = process.platform;
var isWin = /^win/.test(platform);



if(isWin) {
	
	//A windows style glob
		
	var myGlob = function(searchAbs, cb) {
		var searchRel = upath.relative(__dirname, searchAbs);
		if(verbose == true) console.log("Relative path in unix terms:" + searchRel);
		
		
		var glob = new require('glob-fs')({ gitignore: true, nocase:true });  //'nocase: true' only works when it is a folder. So, instead we will either 
														 //be fully upper cased first word or fully lower cased, and we'll try 
														 //searching for both options.		
		
		glob.readdir(searchRel, { gitignore: true, nocase:true }, cb);  //nocase doesn't appear to work with this lib except for dir. See message above  nocase: true
	
	}
	
	
} else {
	//A unix style glob
	var myGlob = function(searchAbs, cb) {
		glob(searchAbs, { "nocase": true }, cb);
	}
}



function trimChar(string, charToRemove) {
    while(string.substring(0,1) == charToRemove) {
        string = string.substring(1);
    }

    while(string.slice(-1) == charToRemove) {
        string = string.slice(0, -1);
    }

    return string;
}

function afterStr(str, searchFor)
{


	var c = str.indexOf(searchFor);
	if (c >= -1)
	{
		// Returns the portion not including the search string;
		// in this example, "Here is a <a>link". If you want the
		// search string included, add the length of the search
		// string to c.
		var start = c + searchFor.length;
		return str.substr(start);
		
	} else {
		return str;
	}

}

function createDateAsUTC(date) {
    return new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()));
}




function getMonthFromString(mon){
	//Courtesy https://stackoverflow.com/questions/13566552/easiest-way-to-convert-month-name-to-month-number-in-js-jan-01
   return new Date(Date.parse(mon +" 1, 2012")).getMonth()+1;
}




function calcImprovement(outputHTML, startWoundSize, endWoundSize, startDate, endDate, startUnderSize, endUnderSize, startExternalSize, endExternalSize)
{
   	var underImprovement = "[NA]";
	var externalImprovement = "[NA]";
   
   //Now show the % improvement. E.g. if a wound started out being 4.5 sqcm, and becomes
   //1.9 sqcm, the percent improvement would be ((4.5 - 1.9) / 4.5) * 100 = 57% improvement
   if((startWoundSize) && (endWoundSize)) {
   
		
   
		var improvement = ((startWoundSize - endWoundSize) / startWoundSize) * 100;
		improvement = Math.round( improvement * 10) / 10;
		
	
		
		if(startUnderSize) {
				//Handle undermining
				var thisImprovement = ((startUnderSize - endUnderSize) / startUnderSize) * 100;
				thisImprovement = Math.round( thisImprovement * 10) / 10;
				if(isNaN(thisImprovement) == false) {
					underImprovement = thisImprovement.toFixed(1);
				}
				
				var thisImprovement = ((startExternalSize - endExternalSize) / startExternalSize) * 100;
				thisImprovement = Math.round( thisImprovement * 10) / 10;
				if(isNaN(thisImprovement) == false) {
					externalImprovement = thisImprovement.toFixed(1);
				}
		}
		
		
		if(isNaN(improvement) == false) {
		
			improvement = improvement.toFixed(1);		//As a string with 1dp
			var startDateDate = startDate;
			var endDateDate = endDate;
			if(endDateDate && startDateDate && endDateDate.getTime() && startDateDate.getTime()) {
				var timeDiff = Math.abs(endDateDate.getTime() - startDateDate.getTime());
			} else {
				var timeDiff = 0;
			}
			var diffDays = Math.ceil(timeDiff / (1000 * 3600 * 24)); 
			
			
			
			if(isNaN(diffDays) == false) {
				if(diffDays > 6) {
			
					if(diffDays > 60) {
						var timeDiff = Math.floor(diffDays / 30) + " months and " + diffDays % 30 + " days";
					} else {
						var timeDiff = Math.floor(diffDays / 7) + " weeks";
					}
		
				} else {
					
				
					if(diffDays == 1) {
						var timeDiff = diffDays + " day";
					} else {	
						var timeDiff = diffDays + " days";
					}	
				}
		
		
				var showColour = "recovering";
		
				if((improvement < 30)&&(diffDays > 14)) {
					showColour = "warning";		//Make the warning red								
				}
			
				if(improvement < 0) {
					showColour = "warning";		//Make the warning red	
				}
		
				if(improvement >= 97) {
					showColour = "recovered";
				}
		
		
				
				outputHTML += ",\"" + improvement + "\",\"" + timeDiff + "\",\"" + showColour + "\",\"" + externalImprovement + "\",\"" + underImprovement + "\"";
			} else {
				//Unknown time period
				
				var showColour = "recovering";
			
				if(improvement < 0) {
					showColour = "warning";		//Make the warning red	
				}
		
				if(improvement >= 97) {
					showColour = "recovered";
				}
				
				
				outputHTML += ",\"" + improvement + "\",\"[Unknown]\",\"" + showColour + "\",\"" + externalImprovement + "\",\"" + underImprovement + "\"";
			}
		} else {
			
			outputHTML += ",\"[Unknown]\",\"[Unknown]\",\"[Unknown]\",\"" + externalImprovement + "\",\"" + underImprovement + "\"";
		
		}
		
		
		
   } else {
		
		outputHTML += ",\"[Unknown]\",\"[Unknown]\",\"[Unknown]\",\"" + externalImprovement + "\",\"" + underImprovement + "\"";
   
   
   }
 
   return outputHTML; 
}





//This function is a copy from show-wound-size.js for the purposes of repeating similar functionality
function outputDirectoryHTML(inpath, htmlcb, isDirectory, sessionId) {
	//Reads through a directory, gets all of the photos in thumbnail format, and the filenames and areas,
	//and display them in a grid. Each image is clickable and will run to the full-page analysis.
	delete items;
	delete htmlList;
	var items = [];
	var htmlList = [];
	items.length = 0;
	htmlList.length = 0;
	var outputHTML = "";  //Field headings
	
	if(verbose == true) console.log("Path incoming:" + inpath);
	
	
	//Get the return path for coming back to this screen again
	var retPath = normalizeInclWinNetworksStyle(inpath, "winstyle");
	retPath = retPath.replace(__dirname, "");
	retPath = retPath.replace(medPhotosRelativePath,"");
	
	var norm = normalizeInclWinNetworksStyle(mainMedImagePath + "/", "winstyle");
	retPath = retPath.replace(norm,"");
	//retPath = retPath.replace(__dirname + '/' + relImagePath,"");
	
	if(isDirectory == true) {	
		//Get all jpg files in this dir
		var thispath = normalizeInclWinNetworksStyle(inpath + "/*.jpg", "winstyle");
	} else {
		//Get all files starting with this text
		var thispath = normalizeInclWinNetworksStyle(inpath + "*.jpg", "winstyle");
	}	
	if(verbose == true) console.log("Directory: " + __dirname);
	thispath = thispath.replace(__dirname, "");
	var searchPath = normalizeInclWinNetworksStyle(resolve(thispath));
	if(verbose == true) console.log("Searching path=" + searchPath);			//Note: the parent script just needs photos/path/here/
	
	
		
	myGlob(searchPath, function(err, items) {
			if(err) {
				if(verbose == true) console.log("Error: " + err);
				return;
					
			} else {
				  if(verbose == true) console.log("Items: " + JSON.stringify(items));
				  
				 
				  
				   
				  async.eachOf(items,
					  // 2nd param is the function that each item is passed to
					  function(item, ind, callback){
					  
					  	
					    htmlList[ind] = {
					    	"html": ""
					    };
					    
						// Call an asynchronous function, often a save() to DB
						if(item.indexOf(thumbnailString) >= 0) {
							//Definitely a .jpg thumbnail image file
							//Append to the list of user options to select
							var rootFilename = item.replace(thumbnailString + "jpg","");
							
							if(verbose == true) console.log("Root filename=" + rootFilename);
							rootFilename = normalizeInclWinNetworksStyle(rootFilename);
							
							if(verbose == true) console.log("Root filename after replacing=" + rootFilename);
							
													
							var rootPicname = afterStr(rootFilename,imagesStart);	//Get rid of any ./photos
							if(verbose == true) console.log("Root picname=" + rootPicname);
							
							rootPicname = trimChar(rootPicname,'/');
							
							if(verbose == true) console.log("Root picname=" + rootPicname);
							
							var confName = rootFilename + ".json";
						
							if(verbose == true) console.log("Loading config:" + confName);
						
							//Determine the subfolders
							var fileName = path.basename(rootPicname);
							var parts = path.dirname(rootPicname).split("/");
							var colId = "";
							var colSub = "";
							if(parts[0]) colId = parts[0];
							if(parts[1]) colSub = parts[1];
							if(colId == ".") colId = "";
				
							
						
							//Load up the config file
							readConfig(confName, function(conf, err) { 
								//Have loaded this config file up
								if(err) {
									if(verbose == true) console.log('ERR:' + err);
									//Most likely a missing json file.
									var thisArea = "[Not found]";
									var underminingStr = "\"[NA]\",\"[NA]\"";
									var woundTypeStr = "\"Unclassified\"";
									
									var newHTML = "\"" + rootPicname + "\",\"" + colId + "\",\"" + colSub + "\",\"" + fileName + "\",\"" + thisArea + "\"," + underminingStr + "," + woundTypeStr;
									if(verbose == true) console.log(newHTML);
									htmlList[ind].html = newHTML;
									
									callback();
								} else {
								
									
									var underminingStr = "\"[NA]\",\"[NA]\"";
									
									if((conf)&&(conf.output)&&(conf.output.fullWound)) {
										var thisArea = conf.output.fullWound.areaSquareCm;
										
										
										//Get the wound size stored
										if(isNaN(thisArea) == false) {
											htmlList[ind].woundSize = thisArea;
										}
										
										//Handle undermining
										if(conf.output.fullWound.underAreaSquareCm) {
											var externalArea = conf.output.fullWound.woundAreaSquareCm;
											var underArea = conf.output.fullWound.underAreaSquareCm;
											
											
											
											if(isNaN(externalArea) == false) {
												htmlList[ind].externalSize = externalArea;
												underminingStr = "\"" + externalArea + "\"";
												
											} else {
												underminingStr = "\"[NA]\"";
											}
											
											if(isNaN(underArea) == false) {
												htmlList[ind].underSize = underArea;
												underminingStr += ",\"" + underArea + "\"";
											} else {
												underminingStr += "\"[NA]\"";
											}
											
										}
										
										
									} else {
										var thisArea = "[Sticker is undetected]";
									}
									
									var woundTypeStr = "\"Unclassified\"";
									if((conf)&&(conf.output)&&(conf.output.woundType)) {
										var woundTypeStr = "\"" + conf.output.woundType + "\"";
									}
								
									
									
									var newHTML = "\"" + rootPicname + "\",\"" + colId + "\",\"" + colSub + "\",\"" + fileName + "\",\"" + thisArea + "\"," + woundTypeStr + "," + underminingStr;
									 if(verbose == true) console.log(newHTML);
									 htmlList[ind].html = newHTML;
									 
									 //Now get the main photo file creation time on disk
									 var origPhotoFile = rootFilename + ".jpg";
									 fs.stat(origPhotoFile, function(err, stats){
										if(stats) {
											var mtime = new Date(stats.mtime);
											htmlList[ind].date = createDateAsUTC(mtime);
											callback();
										} else {
											callback();
										}
									 });
									 
									 
								}
							
								
							});
						
						} else {
						   //Must complete
						   callback();
						
						}
						
						
						
					  },
					  // 3rd param is the function to call when everything's done
					  function(err){
						// All tasks are done now
						if(err) {
						   if(verbose == true) console.log('ERR:' + err);
						 } else {
						   //console.log('Completed all entries!');
						   
						   
						   
						   
						   //Filter out unneeded results
						   var goodHTMLList = [];
						   
						   //Filter out blank values
						   for(var cnt=0; cnt < htmlList.length; cnt++) { 
						   		if(htmlList[cnt].html != "") {
						   			goodHTMLList.push(htmlList[cnt]);
						   							   		
						   		}
						   }
						   
						
						   //Sort into ascending date order
						   goodHTMLList.sort(function(a,b){
								// Turn your strings into dates, and then subtract them
								// to get a value that is either negative, positive, or zero.
								return new Date(a.date) - new Date(b.date);
							});
						   
							
						   var first = true;
						   var startWoundSize = null;
						   var endWoundSize = null;
						   var startDate = null;
						   var endDate = null;
						   
						   var startUnderSize = null;
						   var endUnderSize = null;
						   var startExternalSize = null;
						   var endExternalSize = null;
				  
						   for(var cnt=0; cnt < goodHTMLList.length; cnt++) { 
						   		
						   		//Now we are in the correct date order, we can calculate the start to finish improvements
						   		if(goodHTMLList[cnt].woundSize) {
									if(first == true) {
										startWoundSize = goodHTMLList[cnt].woundSize;
										endWoundSize = goodHTMLList[cnt].woundSize;
										startDate = goodHTMLList[cnt].date;
										endDate = goodHTMLList[cnt].date;
										
										if(goodHTMLList[cnt].underSize) {
											//Handle undermining
											startUnderSize = goodHTMLList[cnt].underSize;
											endUnderSize = goodHTMLList[cnt].underSize;
											startExternalSize = goodHTMLList[cnt].externalSize;
											endExternalSize = goodHTMLList[cnt].externalSize;
										}
										
										first = false;
									} else {
										endWoundSize = goodHTMLList[cnt].woundSize;
										endDate = goodHTMLList[cnt].date;
										
										if(goodHTMLList[cnt].underSize) {
											//Handle undermining
											endUnderSize = goodHTMLList[cnt].underSize;
											endExternalSize = goodHTMLList[cnt].externalSize;
										}
									}
									
									//Now calculate the improvement since the start
									goodHTMLList[cnt].html = calcImprovement(goodHTMLList[cnt].html, startWoundSize, endWoundSize, startDate, endDate, startUnderSize, endUnderSize, startExternalSize, endExternalSize);
									
									
									
								} else {
									//Provide blank improvements
									goodHTMLList[cnt].html += ",\"[Unknown]\",\"[Unknown]\",\"[Unknown]\",\"[NA]\",\"[NA]\"";
								
								}
								
								if(goodHTMLList[cnt].date) {
										var displayDate = goodHTMLList[cnt].date.toUTCString();
										goodHTMLList[cnt].html += ",\"" + displayDate + "\"";
								} else {
										goodHTMLList[cnt].html += ",\"\"";
								}
								
								goodHTMLList[cnt].html += "\r\n";
								
						   		if(goodHTMLList[cnt].html != "") {
						   			outputHTML += goodHTMLList[cnt].html;						   		
						   		}
						   }
						   
						   //process.stdout.write(outputHTML);
						   
						   htmlcb(null, outputHTML);
						 }        
					  }
					);

				  
			 }  			 
  				
				
  				
		});

		

}



function loopAllFolders(inpath, sessionId, cb) 
{


	var finder = new require('findit')(inpath);
	var lineCnt = 0;
	var lineCntComplete = 0;


	finder.on('directory', function (dir, stat, stop) {
		lineCnt ++;
		
		var base = path.basename(dir);
		if (base === '.git' || base === 'node_modules') {
			stop();
		} else {
			if(verbose == true) console.log(dir + '/');
			outputDirectoryHTML(dir + '/', function(err, moreCsvData) {
				lineCntComplete ++;			//Keep track of how many have been completed
				if(err) {
				
				
				} else {
					global.csvData += moreCsvData;
				}
				
				return;
			}, true, sessionId);  
		}
	});
	
	finder.on('end', function () {
		//End only fires on success
		
		//Now wait until lineCntComplete is the same as linCnt
		var keepChecking = 100;		//0.2 seconds * 100 = 20 seconds time-out
		var checking = setInterval(function(){ 
			keepChecking --;
			if(lineCntComplete >= lineCnt) {
				//Fully complete - export the data to a csv file
				clearInterval(checking);		//Stop the timer
				cb(null, "returnParams:?CUSTOMDATA=" + encodeURIComponent(global.csvData) + "&SESSIONID=" + sessionId);
			}
			if(keepChecking <= 0) {
				//Have timed out
				clearInterval(checking);
			}
		}, 200);
		
	
	});
	
	finder.on('stop', function () {
		console.log("Stopped.");
	})
	
	finder.on('error', function (err) {
		console.log("Error: " + err);
	
	});



}


module.exports = { 
	medImage : function(argv, callback) {


		   global.csvData = firstLine;		//Refresh

		   var param = decodeURIComponent(argv[0]);
		   var params = param.split("?");			//Don't include the filename. Sample import: export-TEST.csv%3FsessionId%3D6854f93e-48d4-4c4c-9050-94f465fb8053
		   var opts = queryString.parse(params[1]);	
			console.log(JSON.stringify(opts));
	
			var sessionId = "";
			if(opts.sessionId) {
				sessionId = opts.sessionId;
			}	
			
		   if(session.checkSessionValid(opts.sessionId) > -1) {




		
				readConfig(globalConfigFile, function(conf, err) {
					if(err) {
						//There was a problem loading the master config
						console.log("Error reading master config file:" + err);
					} else {
						//Rearrange default paths to the output folder
						rearrangePaths(conf);
		
						//console.log("Running export with session ID:" + opts.sessionId);
		
						
		
						loopAllFolders(imagesStart, sessionId, function(err, output) {
						
							if(verbose == true) console.log(output);

							var ret = {};
							ret.err = null;
							ret.stdout = output;
							ret.stderr = null;
		
							//Always return { err, stdout, stderr }. Include an error in the first param if necessary.
							callback(null, ret);
						
						});
			
		
					}  //end of master else
				});  //end of master read
	
	
 			} else {
		   		//Not logged in - don't show any photo, other than a login photo
		   		var output = "returnParams:?CUSTOMDATA=Please log in";
		   		
		   		var ret = {};
				ret.err = null;
				ret.stdout = output;
				ret.stderr = null;
			
				//Always return { err, stdout, stderr }. Include an error in the first param if necessary.
				callback(null, ret);	
		   
		   }
	
	}	
}		
		




	   
