
var fs = require('fs');
var upath = require('upath');
var queryString = require('querystring');
var path = require('path');
var resolve = require('path').resolve;

var verbose = false;






module.exports.normalizeInclWinNetworks = function(inpath)
{
	//Tests to see if the path is a Windows network path first, if so, handle this case slightly differently
	//to a normal upath.normalization.
	//Run this before 

	
	
	if((inpath[0] == "\\")&&(inpath[1] == "\\")) {
		
		var retval = "\/" + upath.normalize(inpath);		//Prepend the first slash
	} else {
		if((inpath[0] == "\/")&&(inpath[1] == "\/")) {
			//In unix style syntax, but still a windows style network path
			var retval = "\/" + upath.normalize(inpath);		//Prepend the first slash
		} else {
			var retval =  upath.normalize(inpath);
		}
	}

	if((retval[1]) && (retval[1] == ':')) {
		//Very Likely a Windows path. Capitalise first letter
		retval = retval.charAt(0).toUpperCase() + retval.slice(1);
	}
	
	return retval;

}

module.exports.normalizeInclWinNetworksStyle = function(inpath, style)
{
	//Tests to see if the path is a Windows network path first, if so, handle this case slightly differently
	//to a normal upath.normalization.
	//style can be 'winstyle' i.e. back slashes if on Windows, or defaults to 'unixstyle' which is always forward slashes '/'
	if(!style) {
		var style = "unixstyle";	
	}
	

	
	//Run this before 
	if((inpath[0] == "\\")&&(inpath[1] == "\\")) {
		
		if(style == "winstyle") {
			var retval = "\\" + path.normalize(inpath);		//Prepend the first slash
		} else {
			var retval = "\/" + upath.normalize(inpath);		//Prepend the first slash
		}
	} else {
		if((inpath[0] == "\/")&&(inpath[1] == "\/")) {
			//In unix style syntax, but still a windows style network path
			if(style == "winstyle") {
				var retval = "\/" + path.normalize(inpath);		//Prepend the first slash
			} else {
				var retval = "\/" + upath.normalize(inpath);		//Prepend the first slash
			}
		} else {
			//Normal
			if(style == "winstyle") {
				var retval = path.normalize(inpath);
			} else {
				var retval = upath.normalize(inpath);
			}
		}
	}
	
	
	if(style == "winstyle") {
		if((retval[1]) && (retval[1] == ':')) {
			//Very Likely a Windows path. Capitalise first letter
			retval = retval.charAt(0).toUpperCase() + retval.slice(1);
		}
	}
	
	return retval;

}








module.exports.writeConfig = function(confFile, content, cb) {
	//Write the file nicely formatted again
	fs.writeFile(confFile, JSON.stringify(content, null, 6), function(err) {
		if(err) {
			if(verbose == true) console.log("Error writing config file: " + err);
			cb(err);
			
		} else {
		
			if(verbose == true) console.log("The config file was saved! " + confFile);
			cb(null);
		}
	});
}



module.exports.readConfig = function(confFile, cb) {
	//Reads and updates config with a newdir in the output photos - this will overwrite all other entries there
	//Returns cb(err) where err = null, or a string with the error


	//Write to a json file with the current drive.  This can be removed later manually by user, or added to
	fs.readFile(confFile, function read(err, data) {
		if (err) {
				cb(null, "Sorry, cannot read config file! " + err);
		} else {
			try {
				var content = JSON.parse(data);
			} catch (err) {
				cb(null, "Sorry, cannot read config file! " + err);
				return;
			}	

			cb(content, null);
		};
	});

}



