# wound
Wound Analysis Add-on for MedImage Server

## Introduction

This tool allows a user to take photos of a wound with the MedImage app, alongside a known size sticker.
It will automatically detect and calculate the area of the wound in square cm, and allow tracking of
patients over time.

a) patient ID and wound name search
b) wound detection, and sticker detection
c) colour range picking from the photo
d) a list view, sorted by date order of the current photos for a patient or wound
e) percentage improvement analysis of the the wound over time
f) photo meta-data export to a spreadsheet for further analysis

Note: this add-on requires technical ability to install for Linux/Mac.


## License

This script is commercial software and is available to be licensed from medimage.co.nz on a per-MedImage Desktop installation basis.
See http://medimage.co.nz/guide/#license


## Specifications

__PC-side Platforms__: Windows 32 / 64, Desktop or Server, Windows tablet, Linux.

__Supported Client Apps__: MedImage, Wound Mapp

__Supported Phones__: Android mobiles, Android tablets, iPhone mobiles, iPads

__Resolution of Photos stored__: The resolution of the phone’s camera

__Storage requirements__: Assume an average of 5MB per photo. Usually this will be doubled across a shared network drive. Phones do not retain the photos.

__Networking setup__: Desktop tool connecting into a shared network drive for shared photo storage (unlimited users). Or as a server on a LAN with a shared password (1 – 5 users).

__Accuracy__: Approx 95% area measurement accuracy. You should hold your phone within 5 – 10 degrees square to the wound and sticker to prevent degradation of accuracy, and approximately 20cm away from the wound. See the study here.

https://docs.google.com/spreadsheets/d/1HpnZSVGhzF0B1k0jq_pegGRIMCySJEfizBQ-dea1DD0/edit?usp=sharing

These figures may vary with large wounds around body curves.

__Sticker Requirements__: Flexible, but the default configuration is with Esselte 14mm Yellow stickers. These are not sold with the package, but are standard off-the-shelf items. https://www.warehousestationery.co.nz/product/W2216138.html

__Exported Data__: .csv format, which can be imported into Excel, Google Sheets and other spreadsheet software.

__Wound Measurement tool__: Mobile finger tracing support (approx 97% accurate), Stylus support, Desktop mouse editing for fine-tuning. Immediate access to tracing from the Wound Mapp app. Zoom and pan capability.

__Security__: 256 bit AES Encryption, transferred via the Internet, or your organisation intranet, and on to your own LAN network. Your desktop must have the ability to browse the internet / intranet, but does not need to be exposed to the outside world. This configuration is HISO and HIPAA compliant. Wifi is an optional transfer mechanism. Photos are removed from both the phone and transfer machines after transmission.

__Backups__: Photo backups can be configured to occur in the MedImage Server automatically to a drive of your choosing.



## Pre-requisites

You must have the MedImage Desktop >= 2.0.9 installed already.

Recommended: For performance we recommend you independently install ImageMagick, from https://imagemagick.org/script/download.php



## Installation

Follow the instructions on your download page.

You should use a text editor to change the file config.json and change the default 'basicAuthent' password from 'changeme' to your preferred global password.

This password will be used by all users of the Wound viewing system.


## Using the tool

Click 'See Photos', enter the password 'changeme' or the password you have been given.

Take a photo of a wound alongside a sticker, and give the photo a name, as is standard with the MedImage app.

To enter the analysis tool, open your MedImage Server URL e.g. localhost:5566, and click the 'See Photos' entry on
the left-hand menu.  See the GUIDE.md document (and it's online equivalent http://medimage.co.nz/addon-wound-analysis-guide/)


### To Change the Standard Sticker Size

Open your MedImage Server URL e.g. localhost:5566, and click the 'Settings' entry on
the left-hand menu. Then click on the 'Wound Add-on' option and modify the 'Standard Area of Sticker'.

You can search Google for 'area of circle', for a quick sizing calculator, but please use the 'more details' options
 to get at least 3 decimal places.


## Git Install Method

This option allows easy updates to the tool as they are completed.
You will need to be provided repository access from MedImage themselves. Contact peter AT atomjump.com.

Then, in your MedImage Server's directory

```
cd addons/
git clone https://github.com/atomjump/wound.git
```

and proceed with the same steps as before.


## Building the Windows version and installer


Technical: You should only need to do this if you are a software packager/integrator.


(Optional) To build an installer under Windows you may need to run 

```
npm install
npm install -g flatten-packages
cd [wound root dir]
flatten-packages
```

before packaging the installer script.



## Troubleshooting

If you are on a small 512MB or 1GB VPS system, the nodejs opencv installation can fail due to a lack of memory. Before the build process (i.e. npm install)
you can enable a Swap file to ensure it has enough space. Once this is complete, you can either leave the swap space in, to be able to 
handle larger images, or remove it, if you know you have fairly small images (<= 2000x2000).

See instructions at:

https://www.digitalocean.com/community/tutorials/how-to-configure-virtual-memory-swap-file-on-a-vps


## Known Issue TODO



